<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Session;
use Carbon\Carbon;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $Co_ID=Session::get('Co_ID');
        $Br_ID=0;
        $sp_q="CALL Get_BranchList($Co_ID,$Br_ID)";
        $branch=DB::select($sp_q);
       
        $sp_q="CALL Get_Department($Co_ID,0)";
         $dp_result=DB::select($sp_q);
       
        
         $page_name='Schedule';
        $sp_q="CALL Last_Insert_ID('Sch_Date','schedule_master','1')";
        $qr_date=DB::select($sp_q);
        
if ( $qr_date[0]->max_value==null) {
    $max_day=date('d/M/Y');
} else{
    $carbonDate = Carbon::createFromFormat('Y-m-d',$qr_date[0]->max_value);
        $max_day = $carbonDate->format('d/M/Y');
       // $max_day=;
}



        return view('home',compact('branch','page_name','max_day','dp_result'));
    }
    public function index_report()
    {
        $Co_ID=Session::get('Co_ID');
        $Br_ID=0;
        $sp_q="CALL Get_BranchList($Co_ID,$Br_ID)";
        $branch=DB::select($sp_q);
       
        $sp_q="CALL Get_Department($Co_ID,0)";
         $dp_result=DB::select($sp_q);
       
        
         $page_name='Schedule For Next 7 Day';
        $sp_q="CALL Last_Insert_ID('Sch_Date','schedule_master','1')";
        $qr_date=DB::select($sp_q);
        
if ( $qr_date[0]->max_value==null) {
    $max_day=date('d/M/Y');
} else{
    $carbonDate = Carbon::createFromFormat('Y-m-d',$qr_date[0]->max_value);
        $max_day = $carbonDate->format('d/M/Y');
       // $max_day=;
}



        return view('index_report',compact('branch','page_name','max_day','dp_result'));
    }

    public function get_section(Request $request)
    {
        //dd($request->Br_ID);
      //  dd(Session::get('Co_ID'));
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $sp_q="CALL Get_SectionMaster($Co_ID,$Br_ID)"; //dd( $sp_q);
        // $sp_q='call  '.$viewquery."(?,?,?,?,?)";
         $qr_result=DB::select($sp_q);
       
        return $qr_result;
         
    }


    public function Get_SlotList_Schedule(Request $request)
    {
        $dateString = $request->sh_date;
        $carbonDate = Carbon::createFromFormat('d/M/Y', $dateString);
        $formattedDate = $carbonDate->format('Y-m-d');
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $Sec_ID=$request->Sec_ID;
      // dd("CALL Get_SlotList_Schedule($Co_ID,$Br_ID,$Sec_ID,$formattedDate)");
      $sp_q="CALL Get_SlotList_Schedule($Co_ID,$Br_ID,$Sec_ID,'$formattedDate')";
         $qr_result=DB::select($sp_q);
       
        return $qr_result;
         
    }

    public function Get_Emplyees_Schedule(Request $request)
    {
        $dateString = $request->sh_date;
        $carbonDate = Carbon::createFromFormat('d/M/Y', $dateString);
        $formattedDate = $carbonDate->format('Y-m-d');
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $Sec_ID=$request->Sec_ID;
        $Ts_ID=$request->Ts_ID;
      // dd("CALL Get_SlotList_Schedule($Co_ID,$Br_ID,$Sec_ID,$formattedDate)");
      $sp_q="CALL Get_Emplyees_Schedule($Co_ID,$Br_ID,$Sec_ID,'$formattedDate',$Ts_ID)";
         $qr_result=DB::select($sp_q);
       
        return $qr_result;
         
    }

    public function View_Scheduled_Emplye(Request $request)
    {
        $dateString = $request->sh_date;
        $carbonDate = Carbon::createFromFormat('d/M/Y', $dateString);
        $formattedDate = $carbonDate->format('Y-m-d');
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $Sec_ID=$request->Sec_ID;
        $Ts_ID=$request->Ts_ID;
      // dd("CALL Get_SlotList_Schedule($Co_ID,$Br_ID,$Sec_ID,$formattedDate)");
      $sp_q="CALL View_Scheduled_Emplye($Co_ID,$Br_ID,$Sec_ID,'$formattedDate',$Ts_ID)";
         $qr_result=DB::select($sp_q);
       
        return $qr_result;
         
    }
  


    public function adminHome()

    {


        return view('adminHome');

    }
    public function Employee_Master()

    {
        $Co_ID=Session::get('Co_ID');
        $Br_ID=0;
        $sp_q="CALL Get_BranchList($Co_ID,$Br_ID)";
        $branch=DB::select($sp_q);
       
        $sp_q="CALL Get_Department($Co_ID,0)";
         $dp_result=DB::select($sp_q);
       
       
        $sp_q="CALL Get_Section($Co_ID,0)";
         $sec_result=DB::select($sp_q);
       
        
         $page_name='Schedule';



        return view('Employee_Master',compact('branch','page_name','dp_result','sec_result'));
      


    }
    public function leave_mark()

    {
        $Co_ID=Session::get('Co_ID');
        $Br_ID=0;
        $sp_q="CALL Get_BranchList($Co_ID,$Br_ID)";
        $branch=DB::select($sp_q);
       
        $sp_q="CALL Get_Department($Co_ID,0)";
         $dp_result=DB::select($sp_q);
       
       
        $sp_q="CALL Get_Section($Co_ID,0)";
         $sec_result=DB::select($sp_q);
       
        
         $page_name='Leave Marking ';



        return view('leave_mark',compact('branch','page_name','dp_result','sec_result'));
      


    }

    public function get_emp_code(Request $request){ // dd($request->br_short);
        $br_short=$request->br_short;
        $where='Em_Code LIKE "%'.$br_short.'%"'; 
        $sp_q="CALL MAX_GET('Em_Code','3','employee_master','$where','$br_short','3',@result_param);"; //
      //  $sp_q="SET @p0='Em_Code'; SET @p1='3'; SET @p2='employee_master';  SET @p3='".$where."'; SET @p4='".$br_short."';  SET @p5='2';  SET @p6='';  CALL `MAX_GET`(@p0, @p1, @p2, @p3, @p4, @p5, @p6);  SELECT @p6 AS `result_param`;";
        $sec_result=DB::select($sp_q);   //dd( $sec_result);
        return $sec_result[0]->result_param;
    }
    public function form_sp_employee(Request $request){
        
        $Co_ID=Session::get('Co_ID');
        $sp_q="CALL Get_Employee_master($Co_ID,0)";
        return DB::select($sp_q);
    
    }
    
    public function form_sp_leave(Request $request){
        
        $Co_ID=Session::get('Co_ID');
        $sp_q="CALL LeaveMarker($Co_ID,0)";
        return DB::select($sp_q);
    
    }
    public function get_employee_leave(Request $request){
  
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $param=$request->term."%";
        $results = DB::table('employee_master as A')
        ->select( DB::raw('A.Em_ID as id'), DB::raw('A.Em_Name as value') )
       
        ->where('A.Em_Co_ID', $Co_ID)
        ->where('A.Em_Br_ID', $Br_ID)
        ->where('A.Em_Name', 'like', '%' . $param . '%')
        ->where('A.status', '0')
        ->get(); 
        return $results;
    
    }
    public function edit_employee(Request $request){
        
        $row_id=$request->row_id;
        //DB::raw('GROUP_CONCAT(CONCAT(B.Dep_ID, "-", B.Dep_Name))
        $results = DB::table('employee_master as A')
            ->join('department_master as  B', 'A.EM_Dep_IDS', 'like',  DB::raw('CONCAT("%#",Dep_ID,"#%")'))
            ->select('A.Em_ID','A.Em_Co_ID','A.Em_Br_ID','A.Em_Sec_Id','A.Em_Name','A.Em_Code','A.Em_Place', DB::raw('GROUP_CONCAT(B.Dep_ID) as department') )
            ->groupBy('A.Em_ID','A.Em_Co_ID','A.Em_Br_ID','A.Em_Sec_Id','A.Em_Name','A.Em_Code','A.Em_Place')
            ->where('A.Em_ID', $row_id)
            ->get(); //dd( $results);

        return $results;
    }
    public function Get_schedule_report(Request $request){
        $dateString = $request->sh_date;
        $carbonDate = Carbon::createFromFormat('d/M/Y', $dateString);
        $formattedDate = $carbonDate->format('Y-m-d');
        $Co_ID=Session::get('Co_ID');
        $Br_ID=$request->Br_ID;
        $Sec_ID=$request->Sec_ID;
      // dd("CALL Get_SlotList_Schedule($Co_ID,$Br_ID,$Sec_ID,$formattedDate)");
      $sp_q="CALL Get_7DaysSchedule($Co_ID,$Br_ID,$Sec_ID,'$formattedDate')";
      $results=DB::select($sp_q);
        return $results;
    }

}
