<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->increments('ta_id');
            $table->integer('t_id')->default(0);
            $table->integer('po_id')->default(0);
            $table->integer('to_company')->default(0);
            $table->string('invoice_no',100)->nullable();
            $table->double('invoice_amount',100)->nullable();
            $table->string('file_name',100)->nullable();
            $table->text('remarks')->nullable();
            $table->integer('flag')->default(0)->comment('0=payment pending,1=payment complete,2=part payment');


            $table->timestamp('t_date')->nullable();
            $table->integer('added_by')->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->timestamp('added_on')->nullable();
            $table->integer('status')->default(0);


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
