<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->increments('pod_a_id');
            $table->integer('po_id')->default(0);

            $table->string('po_no',100)->nullable();
            $table->date('po_date')->nullable();
            $table->text('po_description')->nullable();
            $table->double('po_amount',15,2)->default(0);
            $table->double('po_limit',15,2)->default(0);
            $table->date('est_comp_date')->nullable();


            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->integer('added_by')->default(0);
            $table->timestamp('added_on')->nullable();
            $table->integer('status')->default(0);


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_orders');
    }
};
