<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchse_order', function (Blueprint $table) {
            $table->increments('p_id');
            $table->integer('po_id')->default(0);
            $table->string('project_name',200)->nullable();
            $table->string('po_series',200)->nullable();
            $table->string('po_desc',200)->nullable();
            $table->string('po_num',200)->nullable();
            $table->date('po_date',200)->nullable();
            $table->double('project_est_cost',15,2)->default(0);
            
            $table->date('project_est_strt_dt')->nullable();
            $table->date('project_est_end_dt')->nullable();
            $table->double('exp_up_to_dt',15,2)->default(0);
            $table->double('billed_value',15,2)->default(0);
            $table->double('total_paid',15,2)->default(0);
            $table->double('blnc_amt',15,2)->default(0);
            $table->integer('status')->default(0);
           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchssed_order');
    }
};
