<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companysettings', function (Blueprint $table) {
            $table->bigIncrements('CID');
            $table->integer('CompanyType')->nullable();
            $table->string('CompanyCode',10)->nullable();
            $table->string('BranchCode',10)->nullable();
            $table->string('BranchName',100)->nullable();
            $table->integer('GST_STATE')->default(0);
            $table->string('Address1',100)->nullable();
            $table->string('Address2',100)->nullable();
            $table->string('Address3',100)->nullable();
            $table->string('Place',100)->nullable();
            $table->string('LandPhone',15)->nullable();
            $table->string('Mobile',15)->nullable();
            $table->string('Email',100)->nullable();
            $table->integer('decimal_place')->nullable();
            $table->string('font_size',15)->nullable();
            $table->integer('phone_limit')->nullable();








            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companysettings');
    }
};
