<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('complaint_masters', function (Blueprint $table) {
            $table->bigIncrements('is_id');
            $table->integer('C_ID')->nullable();
            $table->integer('B_ID')->nullable();
            $table->integer('S_ID')->nullable();
            $table->integer('S_TYPE')->nullable();
            $table->integer('C_TYPE')->nullable();
            $table->date('C_START_DATE')->nullable();
            $table->date('C_LAST_DATE')->nullable();

             $table->string('description',500)->nullable();
       
            $table->integer('status')->default(0);
         
            
           
            $table->tinyInteger('added_by')->nullable();
            $table->date('added_on')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('complaint_masters');
    }
};
