<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('installed_software', function (Blueprint $table) {
            $table->bigIncrements('com_id');
            $table->integer('C_ID')->nullable();
            $table->integer('S_ID')->nullable();
            $table->integer('S_TYPE')->nullable();
            $table->date('EDATE')->nullable();
            $table->string('caller_name',100)->nullable();
            $table->string('caller_num',100)->nullable();
            $table->string('complaints',500)->nullable();
            $table->string('s_mode',100)->nullable();
            $table->integer('assign_staff')->nullable();
            $table->date('assign_date')->nullable();
            $table->string('work_hr',100)->nullable();
            $table->decimal('cost_service', 15,2);
            $table->string('remarks',500)->nullable();
            $table->tinyInteger('status')->default(0);
            $table->integer('added_by')->nullable();
            $table->date('added_on')->nullable();



        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('installed_software');
    }
};
