<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\labour_master;
use App\Models\contrct_or_sup_masters;
use App\Models\purchase_order;
use App\Models\po_assign;

use App\Models\item_master;
use App\Models\suplier_prdtcs;
use App\Models\transaction;
use App\Models\payment_master;
use App\Models\log_master;
use App\Models\log_details;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Session;

class DataController extends Controller
{





public function log_insert($arr){

  $log_master = new log_master;
  $log_details = new log_details;
  DB::beginTransaction();
  try {
  
$log_id = log_master::max('log_id');
$log_master->log_id=$log_id+1;
$log_master->user_session=$arr['user_session'];
$log_master->log_date_time=date('Y-m-d H:i:s');
$log_master->page=$arr['page'];
$log_master->function=$arr['function'];
$log_master->fn_strt_time=$arr['fn_strt_time'];
$log_master->fn_end_time=$arr['fn_end_time'];
$log_master->ref_id=$arr['ref_id'];
$log_master->mode=$arr['mode'];
$log_master->user_id=$arr['user_id'];
$log_master->branch_id=$arr['branch_id'];
$log_master->company_id=$arr['company_id'];

$log_master->save(); 

$log_details->log_id=$log_id+1;
$log_details->data=$arr['data'];
$log_details->save(); 

DB::commit();
  }catch (\Exception $e) {
    
    DB::rollback();

    //return response()->json(['message' => 'Failed to insert data'], 500);
}
 

}





public function log_insert_master($arr){

  $log_master = new log_master;


  
$log_id = log_master::max('log_id');
$log_master->log_id=$log_id+1;
$log_master->user_session=$arr['user_session'];
$log_master->log_date_time=date('Y-m-d H:i:s');
$log_master->page=$arr['page'];
$log_master->function=$arr['function'];
$log_master->fn_strt_time=$arr['fn_strt_time'];
$log_master->fn_end_time=$arr['fn_end_time'];
$log_master->ref_id=$arr['ref_id'];
$log_master->mode=$arr['mode'];
$log_master->user_id=$arr['user_id'];
$log_master->branch_id=$arr['branch_id'];
$log_master->company_id=$arr['company_id'];

return $log_id+1;

}
public function log_insert_detail($log_id,$arr){

  $log_details = new log_details;

 

$log_details->log_id=$log_id;
$log_details->data=$arr['data'];
$log_details->save(); 


}









  public function load_pdts_sup(Request $request){
    // gettype($row_id);

    // explode(',', $row_id);


   $items= item_master::select('product_id','p_name')->where('status','=',0)->get();

  return  $items;
  }

  public function load_sups(Request $request){
    // gettype($row_id);

    // explode(',', $row_id);


   $items= contrct_or_sup_masters::select('c_id','c_name')->where([['status','=',0],['type','=',1]])->get();

  return  $items;
  }



  public function get_data(Request $request)

  {
$f_name=$request->fn_name;

$d=$this->$f_name($request->row_id);


      
       

          return $d;




  }


 


  public function op_supplier(Request $request)
  {


    $fn_strt_time=date('H:i:s');
    $user_session=Session::get('login_session');


    $title="Supplier ";
    $type=$request->type;
    $hidden_status= $request->hidden_status;

    $data = new contrct_or_sup_masters;
    
    $data->c_name= $request->c_name;
    $data->address= $request->address;
    $data->phone= $request->phone;
    $data->phone2= $request->phone2;
    
    $data->added_by= $request->added_by;
    $data->type=  $type;
    $data->user_session=  $user_session;
    $data->added_on=date('Y-m-d H:i:s');


$p_arr=explode(",",$request->product_id);


if($hidden_status==0){

  $count = contrct_or_sup_masters::where([['c_name', '=',$request->c_name],['phone', '=',$request->phone],['type', '=',1]])->count();

  if($count>0){
    $flag="0";
    $msg=$title." Duplicate Supplier";
  
  }
  else{


    if($data->save()){
$l_cid=DB::table('contrct_or_sup_masters')->select('c_id')->orderBy('c_id', 'DESC')->first();

      
if(sizeof($p_arr)>0){
  

  foreach ($p_arr as $value) {
    $data1 = new suplier_prdtcs;

    if($value!=0){


      
      $data1->sup_id=$l_cid->c_id;
      $data1->supname=$data->c_name;
      $data1->prdct_id=$value;
      $data1->added_by=$request->added_by;
      $data1->added_on=date('Y-m-d H:i:s');
      
      
      $data1->save();
    }
  } 

}
      
$log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'supplier','function'=>'op_supplier',
'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->c_id,'mode'=>0,'user_id'=>Session::get('user_id'),
'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
);
   $log_insert = $this->log_insert($log_arr);


      $flag="1";
      $msg=$title." Inserted Successfully ";
     }else{
       $flag="0";
      $msg=$title." Insertion  Failed ";
     }







  }




}




else  if($hidden_status==1){
        
  $upd= DB::table('contrct_or_sup_masters')->where('c_id', $request->row_id)->update(
     ['c_name' => $request->c_name,
     'address' => $request->address,
     'phone' => $request->phone,
     'phone2' => $request->phone2
  ]);

 if($upd==0||$upd==1){
  

      
  if(sizeof($p_arr)>0){
  
    DB::table('suplier_prdtcs')->where('sup_id',$request->row_id)->delete(); 

    foreach ($p_arr as $value) {
      $data1 = new suplier_prdtcs;
  
      if($value!=0){
  
  
        
        $data1->sup_id=$request->row_id;
        $data1->supname=$request->c_name;
        $data1->prdct_id=$value;
        $data1->added_by=$request->added_by;
        $data1->added_on=date('Y-m-d H:i:s');
        
        
        $data1->save();
      }
   
  
  
  
    } 
  
  }



  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'supplier','function'=>'op_supplier',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>1,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);


  
  $flag="1";
  $msg=$title."Update Successfully ";
 }else{
   $flag="0";
  $msg=$title."Updation  Failed ";
 }
 }

else  if($hidden_status==2){
 
  $upd= DB::table('contrct_or_sup_masters')->where('c_id', $request->row_id)->update(
     ['status' => 1]);

 if($upd==0||$upd==1){
  
  
  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'supplier','function'=>'op_supplier',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>2,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);


  $flag="1";
  $msg=$title."Delete Successfully ";
 }else{
   $flag="0";
  $msg=$title."Delete Failed ";
 }
 }




 return response()->json(['flag'=> $flag,'msg'=> $msg]);



  }



    public function op_contct_or_sup(Request $request)
    {
      $fn_strt_time=date('H:i:s');
      $user_session=Session::get('login_session');
    
      $title='';
      $type=$request->type;

        $title="Contractor";



      $hidden_status= $request->hidden_status;

           $data = new contrct_or_sup_masters;
    

      $data->c_name= $request->c_name;
      $data->address= $request->address;
      $data->phone= $request->phone;
      $data->phone2= $request->phone2;
      
      $data->added_by= $request->added_by;
      $data->type=  $type;
      $data->user_session=  $user_session;
      $data->added_on=date('Y-m-d H:i:s');


 
    
  
       
      if($hidden_status==0){





  $count = contrct_or_sup_masters::where([['username', '=',$request->username],['password', '=',$request->pass]])->count();



  $data->username=$request->username;
  $data->password=$request->pass;

if($count==0){
  if($data->save()){



    $l_cid=DB::table('contrct_or_sup_masters')->select('c_id')->orderBy('c_id', 'DESC')->first();

    $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'contractor','function'=>'op_contct_or_sup',
'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->c_id,'mode'=>0,'user_id'=>Session::get('user_id'),
'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
);
   $log_insert = $this->log_insert($log_arr);
      
    $flag="1";
    $msg=$title." Inserted Successfully ";
   }else{
     $flag="0";
    $msg=$title." Insertion  Failed ";
   }

}

else{
  $flag="0";
  $msg=$title." Duplicate Username And Password";

}


      






       }


       else  if($hidden_status==1){
        
         $upd= DB::table('contrct_or_sup_masters')->where('c_id', $request->row_id)->update(
            ['c_name' => $request->c_name,
            'address' => $request->address,
            'phone' => $request->phone,
            'phone2' => $request->phone2
         ]);

        if($upd==0||$upd==1){
         
         
          $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'contractor','function'=>'op_contct_or_sup',
          'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>1,'user_id'=>Session::get('user_id'),
          'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
          );
             $log_insert = $this->log_insert($log_arr);

         $flag="1";
         $msg=$title."Update Successfully ";
        }else{
          $flag="0";
         $msg=$title."Updation  Failed ";
        }
        }

       else  if($hidden_status==2){
        
         $upd= DB::table('contrct_or_sup_masters')->where('c_id', $request->row_id)->update(
            ['status' => 1]);

        if($upd==0||$upd==1){
         
          $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'contractor','function'=>'op_contct_or_sup',
          'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>2,'user_id'=>Session::get('user_id'),
          'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
          );
             $log_insert = $this->log_insert($log_arr);
         $flag="1";
         $msg=$title."Delete Successfully ";
        }else{
          $flag="0";
         $msg=$title."Delete Failed ";
        }
        }


     


        return response()->json(['flag'=> $flag,'msg'=> $msg]);
      
    }  
    




public function edit_contr_sup(Request $request)
{
   
     $cntrcts = DB::table('contrct_or_sup_masters')->where('c_id', $request->row_id)->first();
   




     $pdts = DB::table('suplier_prdtcs')
     ->select(DB::raw("GROUP_CONCAT(prdct_id SEPARATOR ',') as `prdct_id`"))
    
    ->where('sup_id',$request->row_id)
     ->get();



   return response()->json(['cntrcts'=> $cntrcts,'pdts'=> $pdts]);
}


public function op_item_master(Request $request)
{
  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');

  
    $title="Item ";
 
  $hidden_status= $request->hidden_status;

       $data = new item_master;


  $data->p_name= $request->p_name;
  $data->cat_id= $request->cat_id;
  $data->product_code= $request->product_code;

  $data->unit= $request->unit;
  
  $data->added_by= $request->added_by; 
  $data->user_session=  $user_session;

  $data->added_on=date('Y-m-d H:i:s');


$sarr=$request->sup_id;


   
  if($hidden_status==0){


 
   if($data->save()){



    $l_cid=DB::table('item_masters')->select('product_id')->orderBy('product_id', 'DESC')->first();        
if(sizeof($sarr)>0){
  




  foreach ($sarr as $value) {
    $data1 = new suplier_prdtcs;

    if($value!=0){


      
      $data1->sup_id=$value;
      $data1->supname=DB::table('contrct_or_sup_masters')->where('c_id', $value)->pluck('c_name');
      $data1->prdct_id=$l_cid->product_id;
      $data1->added_by=$request->added_by;
      $data1->added_on=date('Y-m-d H:i:s');
      
      
      $data1->save();
    }
 



  } 

}

$log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'item','function'=>'op_item_master',
'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->product_id,'mode'=>0,'user_id'=>Session::get('user_id'),
'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
);
   $log_insert = $this->log_insert($log_arr);

    $flag="1";
    $msg=$title." Inserted Successfully ";
   }else{
     $flag="0";
    $msg=$title." Insertion  Failed ";
   }
   }


   else  if($hidden_status==1){
    
     $upd= DB::table('item_masters')->where('product_id', $request->row_id)->update(
        ['p_name' => $request->p_name,
        'cat_id' => $request->cat_id,
        'product_code' => $request->product_code,
        'unit' => $request->unit
     ]);

    if($upd==0||$upd==1){
     
           
  if(sizeof($sarr)>0){
  
    DB::table('suplier_prdtcs')->where('prdct_id',$request->row_id)->delete(); 

    foreach ($sarr as $value) {
      $data1 = new suplier_prdtcs;
  
      if($value!=0){
  
  
        
        $data1->sup_id=$value;
        $data1->supname=DB::table('contrct_or_sup_masters')->where('c_name', $value)->pluck('c_name');
        $data1->prdct_id=$request->row_id;
        $data1->added_by=$request->added_by;
        $data1->added_on=date('Y-m-d H:i:s');
        
        
        $data1->save();
      }
   
  
  
  
    } 
  
  }





  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'item','function'=>'op_item_master',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>1,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);


     $flag="1";
     $msg=$title."Update Successfully ";
    }else{
      $flag="0";
     $msg=$title."Updation  Failed ";
    }
    }

   else  if($hidden_status==2){
    
     $upd= DB::table('item_masters')->where('product_id', $request->row_id)->update(
        ['status' => 1]);

    if($upd==0||$upd==1){
     
      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'item','function'=>'op_item_master',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>2,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);


     $flag="1";
     $msg=$title."Delete Successfully ";
    }else{
      $flag="0";
     $msg=$title."Delete Failed ";
    }
    }


 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
} 






public function edit_item_master(Request $request)
{
   
     $items = DB::table('item_masters')->where('product_id', $request->row_id)->first();


     





     $sups = DB::table('suplier_prdtcs')
     ->select(DB::raw("GROUP_CONCAT(sup_id SEPARATOR ',') as `sup_id`"))
    
    ->where('prdct_id',$request->row_id)
     ->get();



   return response()->json(['items'=> $items,'sups'=> $sups]);
}





public function op_lbr_master(Request $request)
{

  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');
  
    $title="labour ";
 
  $hidden_status= $request->hidden_status;

       $data = new labour_master;


  $data->lab_name= $request->lab_name;
  $data->section= $request->section;
  $data->lab_code= $request->lab_code;

  
  $data->added_by= $request->added_by;
  $data->branch_id= $request->company_id;

  $data->added_on=date('Y-m-d H:i:s');





   
  if($hidden_status==0){
   if($data->save()){

    $l_cid=DB::table('labour_masters')->select('lab_id')->orderBy('lab_id', 'DESC')->first(); 



    $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'labour_master','function'=>'op_lbr_master',
    'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->lab_id,'mode'=>0,'user_id'=>Session::get('user_id'),
    'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
    );
       $log_insert = $this->log_insert($log_arr);


    $flag="1";
    $msg=$title." Inserted Successfully ";
   }else{
     $flag="0";
    $msg=$title." Insertion  Failed ";
   }
   }


   else  if($hidden_status==1){
    
     $upd= DB::table('labour_masters')->where('lab_id', $request->row_id)->update(
        ['lab_name' => $request->lab_name,
        'section' => $request->section,
        'lab_code' => $request->lab_code
     ]);

    if($upd==0||$upd==1){
      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'labour_master','function'=>'op_lbr_master',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->lab_id,'mode'=>1,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);
      
     
     $flag="1";
     $msg=$title."Update Successfully ";
    }else{
      $flag="0";
     $msg=$title."Updation  Failed ";
    }
    }

   else  if($hidden_status==2){
    
     $upd= DB::table('labour_masters')->where('lab_id', $request->row_id)->update(
        ['status' => 1]);

    if($upd==0||$upd==1){
     
      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'labour_master','function'=>'op_lbr_master',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->lab_id,'mode'=>2,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);

     $flag="1";
     $msg=$title."Delete Successfully ";
    }else{
      $flag="0";
     $msg=$title."Delete Failed ";
    }
    }


 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
} 





public function edit_lbr_master(Request $request)
{
   
     $edit = DB::table('labour_masters')->where('lab_id', $request->row_id)->first();

   return response()->json($edit);
}






  public function op_project(Request $request)
  { $fn_strt_time=date('H:i:s');
    $user_session=Session::get('login_session');
  




    $title="Purchase Order ";
    $hidden_status= $request->hidden_status;

    $data = new purchase_order;
    $d="%".date('Y')."-".date('m')."%";
         $count = DB::table('purchase_orders')->where([['added_on','like',$d]])->get()->count();
         $count++;

        $newDate =  $ndate = Carbon::createFromFormat('d-m-Y', $request->est_comp_date)->format('Y-m-d');
        $po_date =  $ndate = Carbon::createFromFormat('d-m-Y', $request->po_date)->format('Y-m-d');

//  dd();
$po_short_code='PO';
if($hidden_status==0){
    
    $data->po_con_no= sprintf('%s/%s-%05d', date('Y'),  date('m'), $count);

    if($request->po_short_code!=''){
      $po_short_code=$request->po_short_code;
    }
    $data->po_no= $request->po_no;
    $data->po_date= $po_date;
    $data->po_description= $request->po_description;
    $data->po_short_code= $po_short_code;
    $data->po_amount= $request->po_amount;
    $data->po_limit= $request->po_limit;
    $data->est_comp_date= $newDate;
    
    $data->added_by= $request->added_by;
    $data->company_id=  $request->company_id;


    $data->user_session=  $user_session;

    $data->added_on=date('Y-m-d H:i:s');
  $count = purchase_order::where([['po_no', '=',$request->po_no],['status', '=',0]])->count();
  $count2 = purchase_order::where([['po_short_code', '=',$request->po_short_code],['status', '=',0]])->count();

  if($count>0 || $count2>0){
    $flag="0";
    $msg=$title." Duplicate Purchase Order";
  
  }
  else{



    if($data->save()){


      $l_cid=DB::table('purchase_orders')->select('pod_a_id')->orderBy('pod_a_id', 'DESC')->first(); 


      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project','function'=>'op_project',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$l_cid->pod_a_id,'mode'=>0,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);


      $flag="1";
      $msg=$title." Inserted Successfully ";
     }else{
       $flag="0";
      $msg=$title." Insertion  Failed ";
     }



  }
} else  if($hidden_status==1){
        
        
  $data = purchase_order::where('pod_a_id', $request->row_id)
  ->update([
    'po_no'=> $request->po_no,
    'po_date'=> $po_date,
    'po_description'=> $request->po_description,
    'po_short_code'=> $request->po_short_code,
    'po_amount'=> $request->po_amount,
    'po_limit'=> $request->po_limit,
    'est_comp_date'=> $newDate,
    
    'added_by'=> $request->added_by,
    'company_id'=>  $request->company_id,
    'added_on'=>date('Y-m-d H:i:s')
       ]);
    //dd($data);
if($data){
  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project','function'=>'op_project',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>1,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);


  $flag="1";
  $msg=$title."Update Successfully ";
 }else{
   $flag="0";
  $msg=$title."Updation  Failed ";
 }
 }

else  if($hidden_status==2){
 
  $upd= DB::table('purchase_orders')->where('pod_a_id', $request->row_id)->update(
     ['status' => 1]);

 if($upd==0||$upd==1){
  
  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project','function'=>'op_project',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>2,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);
  
  $flag="1";
  $msg=$title."Delete Successfully ";
 }else{
   $flag="0";
  $msg=$title."Delete Failed ";
 }
 }




 return response()->json(['flag'=> $flag,'msg'=> $msg]);



  }

public function edit_project(Request $request)
{
   
     $edit = DB::table('purchase_orders')->where('pod_a_id', $request->row_id)->select('pod_a_id', 'po_id', 'po_con_no', 'po_no','po_short_code',  DB::raw('DATE_FORMAT(po_date,"%d-%m-%Y")po_date'), 'po_description', 'po_amount', 'po_limit',  DB::raw('DATE_FORMAT(est_comp_date,"%d-%m-%Y")est_comp_date'))->first();

   return response()->json($edit);
}

public function fetch_po_no(Request $request)
{

  

  //$data = DB::table('purchase_orders')->select('pod_a_id', 'po_id','po_no', 'po_con_no','po_amount','po_description',DB::raw('DATE_FORMAT(est_comp_date, "%d-%m-%Y") as po_date'))->where(DB::raw('concat(po_con_no,po_no)'),'LIKE','%'.$request->ename.'%')->get();

  $data = DB::table('purchase_orders AS po')
  ->select('po.pod_a_id','po.po_id','po.po_no','po.po_con_no','po.po_description','po.po_amount',
DB::raw('po.po_amount-SUM(C.est_cost) AS blnc_po'),DB::raw('DATE_FORMAT(po.est_comp_date, "%d-%m-%Y") as po_date'))

  ->leftjoin('po_assigns AS C', 'C.po_id', '=', 'po.pod_a_id')
  ->where([[DB::raw('concat(po.po_con_no,po.po_no)'),'LIKE','%'.$request->ename.'%'],['po.status','=',0]])
  ->groupBy('po.pod_a_id','po.po_id','po.po_no','po.po_con_no','po.po_amount','po.po_description',DB::raw('DATE_FORMAT(po.est_comp_date, "%d-%m-%Y")'))
  ->get();





   return response()->json($data);
}
public function fetch_po_no_val(Request $request)
{

  
$str='po.'.$request->id;
  //$data = DB::table('purchase_orders')->select('pod_a_id', 'po_id','po_no', 'po_con_no','po_amount','po_description',DB::raw('DATE_FORMAT(est_comp_date, "%d-%m-%Y") as po_date'))->where(DB::raw('concat(po_con_no,po_no)'),'LIKE','%'.$request->ename.'%')->get();

  $data = DB::table('purchase_orders AS po')
  ->select('po.pod_a_id','po.po_id','po.po_no','po.po_con_no','po.po_description','po.po_amount',$str.' as value',
DB::raw('po.po_amount-SUM(C.est_cost) AS blnc_po'),DB::raw('DATE_FORMAT(po.est_comp_date, "%d-%m-%Y") as po_date'))

  ->leftjoin('po_assigns AS C', 'C.po_id', '=', 'po.pod_a_id')
  ->where([[DB::raw('concat(po.po_con_no,po.po_no)'),'LIKE','%'.$request->ename.'%'],['po.status','=',0]])
  ->groupBy('po.pod_a_id','po.po_id','po.po_no','po.po_con_no','po.po_amount','po.po_description',DB::raw('DATE_FORMAT(po.est_comp_date, "%d-%m-%Y")'))
  ->get();





   return response()->json($data);
}



public function fetch_contrctr(Request $request)
{
   

  $data = DB::table('contrct_or_sup_masters')->select('c_id', 'c_name')->where([['c_name','LIKE','%'.$request->ename.'%'],['type','=',0]])->get();


   return response()->json($data);
}




public function op_po_assign(Request $request)
{

  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');

$title='';
$title="Purchase Order Assign";
$hidden_status= $request->hidden_status;

 $data = new po_assign;

 $pa_id = po_assign::where('status', 0)->max('pa_id');


 $po_date =  Carbon::createFromFormat('d-m-Y', $request->po_date)->format('Y-m-d');
 $p_asg_dt =  Carbon::createFromFormat('d-m-Y', $request->p_asg_dt)->format('Y-m-d');
 $completion_dt =  Carbon::createFromFormat('d-m-Y', $request->completion_dt)->format('Y-m-d');



 $p_code=DB::table('purchase_orders')->select('po_no')->where('pod_a_id',$request->po_id)->first();

 $pa_no = po_assign::where([['status','=','0'],['pa_no','LIKE','%'.$p_code->po_no.'%']])->max('pa_no');
 $pa_no1='';
 if(!$pa_no){
   $pa_no=str_pad(1, 4, '0', STR_PAD_LEFT);
   $pa_no1=$p_code->po_no.'/'.(string) $pa_no;

 }else{
$res=explode('/',$pa_no);

$pa_no=str_pad((int)$res[1]+1, 4, '0', STR_PAD_LEFT);

$pa_no1=$res[0].'/'.$pa_no;
 }



 $data->pa_no= $pa_no1;


  $data->pa_id= $pa_id+1;
 


  $data->po_id= $request->po_id;
  $data->contrct_id= $request->contrct_id;
  $data->descrpt= $request->descrpt;
  $data->po_date= $po_date;
  $data->p_asg_dt= $p_asg_dt;
  $data->completion_dt= $completion_dt;
  $data->est_cost= $request->est_cost;
  $data->branch_id= $request->branch_id;
  
  $data->added_by= $request->added_by;
  $data->user_session=  $user_session;

  $data->added_on=date('Y-m-d H:i:s');

 
  if($hidden_status==0){


    if($data->save()){



      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project_assign','function'=>'op_po_assign',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$pa_id+1,'mode'=>0,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);
  
      $flag="1";
      $msg=$title." Inserted Successfully ";
      }else{
       $flag="0";
      $msg=$title." Insertion  Failed ";
      }

  






   }


   else  if($hidden_status==1){
    
     $upd= DB::table('po_assigns')->where('pa_id', $request->row_id)->update(
        ['contrct_id' => $request->contrct_id,
        'descrpt' => $request->descrpt,
        'po_date' => $po_date,
        'p_asg_dt' => $p_asg_dt,
        'completion_dt' => $completion_dt,
        'est_cost' => $request->est_cost
     ]);

    if($upd==0||$upd==1){
     
     
     $flag="1";
     $msg=$title."Update Successfully ";
    }else{
      $flag="0";
     $msg=$title."Updation  Failed ";
    }
    }

   else  if($hidden_status==2){
    
     $upd= DB::table('po_assigns')->where('pa_id', $request->row_id)->update(
        ['status' => 1]);

    if($upd==0||$upd==1){
     
      $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project_assign','function'=>'op_po_assign',
      'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>2,'user_id'=>Session::get('user_id'),
      'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
      );
         $log_insert = $this->log_insert($log_arr);
     $flag="1";
     $msg=$title."Delete Successfully ";
    }else{
      $flag="0";
     $msg=$title."Delete Failed ";
    }
    }


 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
}  



public function load_prev_assgns(Request $request)
{
   

$data = DB::table('po_assigns AS po')
    ->select('po.pa_id','C.c_name',DB::raw('DATE_FORMAT(po.p_asg_dt, "%d-%m-%Y") as p_asg_dt'),
    DB::raw('DATE_FORMAT(po.completion_dt, "%d-%m-%Y") as completion_dt'),'po.descrpt','po.est_cost')
    ->join('contrct_or_sup_masters AS C', 'C.c_id', '=', 'po.contrct_id')
    ->where([['po.po_id', $request->pod_id],['po.status','=',0]])
    ->get();



   return response()->json($data);
}



public function edit_po_assign(Request $request)
{
   


     $data = DB::table('po_assigns AS po')
    ->select('po.pa_id','C.c_name',DB::raw('DATE_FORMAT(po.p_asg_dt, "%d-%m-%Y") as p_asg_dt'),
    DB::raw('DATE_FORMAT(po.completion_dt, "%d-%m-%Y") as completion_dt'), DB::raw('DATE_FORMAT(po.po_date, "%d-%m-%Y") as po_date'),'po.descrpt','D.po_con_no','D.po_no','C.c_id','po.est_cost')
    ->join('contrct_or_sup_masters AS C', 'C.c_id', '=', 'po.contrct_id')
    ->join('purchase_orders AS D', 'D.pod_a_id', '=', 'po.po_id')
    ->where('po.pa_id', $request->row_id)
    ->get();

   return response()->json($data);
}



public function fetch_pa_max_series(Request $request){



  $p_code=DB::table('purchase_orders')->select('po_no')->where('pod_a_id',$request->po_id)->first();

  $pa_no = po_assign::where([['status','=','0'],['pa_no','LIKE','%'.$p_code->po_no.'%']])->max('pa_no');
  $pa_no1='';
  if(!$pa_no){
    $pa_no=str_pad(1, 4, '0', STR_PAD_LEFT);
    $pa_no1=$p_code->po_no.'/'.(string) $pa_no;

  }else{
$res=explode('/',$pa_no);

$pa_no=str_pad((int)$res[1]+1, 4, '0', STR_PAD_LEFT);

$pa_no1=$res[0].'/'.$pa_no;
  }





// if(!$pa_id){
//   $pa_id=0;
// }
//   $pa_no=str_pad($pa_id+1, 4, '0', STR_PAD_LEFT);
//   $pa_no1=$p_code->po_short_code.'/'.(string) $pa_no;

  return response()->json($pa_no1);

}




public function load_details_pa(Request $request)
{
   
  $data = DB::table('po_assigns AS po')
  ->select('po.pa_id','C.c_name',DB::raw('DATE_FORMAT(po.p_asg_dt, "%d-%m-%Y") as p_asg_dt'),
  DB::raw('DATE_FORMAT(po.completion_dt, "%d-%m-%Y") as completion_dt'), DB::raw('DATE_FORMAT(po.po_date, "%d-%m-%Y") as po_date'),'po.descrpt','D.po_con_no','D.po_no','C.c_id','po.est_cost'
  ,'U.name as ad_by')
  ->join('contrct_or_sup_masters AS C', 'C.c_id', '=', 'po.contrct_id')
  ->join('purchase_orders AS D', 'D.pod_a_id', '=', 'po.po_id')
  ->join('users AS U','U.id','=','po.added_by')
  ->where('po.pa_id', $request->pa_id)
  ->get();



   return response()->json($data);
}

public function import_bill(Request $request)
{

  $po_id=$request->po_id;
  $ext = $request->file->getClientOriginalExtension();

$item_img=date('YmdHis').'_'.$po_id.'.'.$ext;
$flag=1;
$msg='';



  if(move_uploaded_file($request->file, '../public/uploads/' . $item_img)){
    $flag=0;
    $msg='File Uploaded Succesfully!!!';


  }else{

    $flag=1;
    $msg='File Uploaded Failed';

  }


  return response()->json(['flag'=> $flag,'msg'=> $msg,'item_img'=> $item_img]);

}







public function op_trans_bill(Request $request)
{
  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');

$title='';
$title="Transaction";
$hidden_status= $request->hidden_status;

 $data = new transaction;
 $data2 = new payment_master;

 $t_id = transaction::max('t_id');


 $t_date =  Carbon::createFromFormat('d-m-Y', $request->t_date)->format('Y-m-d');

$data->t_id= $t_id+1;
 


  $data->po_id= $request->po_id;
  $data->to_company= 1;
  $data->invoice_no= $request->invoice_no;
  $data->t_date= $t_date;
  $data->invoice_amount= $request->invoice_amount;
  $data->file_name= $request->item_img;
  $data->branch_id= $request->branch_id;
  
  $data->added_by= $request->added_by;

  $data->user_session=  $user_session;

  $data->added_on=date('Y-m-d H:i:s');

 
  if($hidden_status==0){


    if($data->save()){

$data2->trans_type=0;
$data2->bill_id=$t_id+1;
$data2->type=2;
$data2->party_id=1;
$data2->debit=$request->invoice_amount;
$data2->po_id=$request->po_id;
$data2->branch_id=$request->branch_id;
$data2->added_by=$request->added_by;
$data2->user_session=  $user_session;
$data2->added_on=date('Y-m-d H:i:s');
$data2->t_date=date('Y-m-d');
$data2->save();



$log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'transaction','function'=>'op_trans_bill',
'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$t_id+1,'mode'=>0,'user_id'=>Session::get('user_id'),
'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
);
   $log_insert = $this->log_insert($log_arr);

  
      $flag="1";
      $msg=$title." Inserted Successfully ";
      }else{
       $flag="0";
      $msg=$title." Insertion  Failed ";
      }

  






   }


   else  if($hidden_status==1){
    
     $upd= DB::table('transactions')->where('t_id', $request->row_id)->update(
        ['invoice_no' => $request->invoice_no,
        'invoice_amount' => $request->invoice_amount,
        't_date' => Carbon::createFromFormat('d-m-Y', $request->t_date)->format('Y-m-d'),
        'file_name' => $request->item_img,
        'remarks' => $request->remarks
     ]);

    if($upd==0||$upd==1){
     
     
     $flag="1";
     $msg=$title."Update Successfully ";
    }else{
      $flag="0";
     $msg=$title."Updation  Failed ";
    }
    }

   else  if($hidden_status==2){
    
     $upd= DB::table('transactions')->where('t_id', $request->row_id)->update(
        ['status' => 1]);

    if($upd==0||$upd==1){
      $upd2= DB::table('payment_masters')->where([['bill_id','=',$request->row_id],['type','=','2'],['trans_type','=','0']])->update(
        ['status' => 1]);



        $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'transaction','function'=>'op_trans_bill',
        'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$t_id+1,'mode'=>2,'user_id'=>Session::get('user_id'),
        'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
        );
           $log_insert = $this->log_insert($log_arr);


     
     $flag="1";
     $msg=$title."Delete Successfully ";
    }else{
      $flag="0";
     $msg=$title."Delete Failed ";
    }
    }


 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
}  


public function edit_trans_bill(Request $request)
{
   


     $data = DB::table('transactions AS ta')
    ->select('ta.t_id','ta.invoice_no','ta.invoice_amount','ta.file_name','ta.remarks','ta.po_id',
    DB::raw('DATE_FORMAT(ta.t_date, "%d-%m-%Y") as t_date'),'d.po_con_no','d.po_no','d.po_description','D.po_date'
    )
   
    ->join('purchase_orders AS D', 'D.pod_a_id', '=', 'ta.po_id')
    ->where('ta.t_id', $request->row_id)
    ->get();

   return response()->json($data);
}

public function fetch_bill_for_settle(Request $request)
{
   
     $edit = DB::table('transactions')->where('t_id', $request->row_id)->select('invoice_amount', 'invoice_no', 'file_name','settle_amt')->first();

   return response()->json($edit);
}






public function op_save_settlement(Request $request)
{

  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');

$title='';
$title="Transaction";
$hidden_status= $request->hidden_status;

 $data = new transaction;
 $data2 = new payment_master;

$flag=1;
if($request->part_pay==1){
  $flag=2;
}
 
  $upd= DB::table('transactions')->where('t_id', $request->row_id)->update(
    ['flag' => $flag,
    'settle_remark' => $request->m_remarks,
    'settle_amt' => transaction::where('t_id', $request->row_id)->pluck('settle_amt')->first()+$request->s_amt,
    'settled_on' => date('Y-m-d H:i:s')
 ]);

if($upd==0||$upd==1){
 
$po_id=DB::table('transactions')->where('t_id', $request->row_id)->select('po_id')->first();
  $data2->trans_type=1;
$data2->bill_id=$request->row_id;
$data2->type=2;
$data2->party_id=1;
$data2->credit=$request->s_amt;

$data2->po_id=$po_id->po_id;

$data2->branch_id=$request->branch_id;
$data2->company_id=$request->branch_id;
$data2->added_by=$request->added_by;
$data2->user_session=$user_session;
$data2->t_date=date('Y-m-d');
$data2->added_on=date('Y-m-d H:i:s');
$data2->save();


$log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'transaction','function'=>'op_save_settlement',
'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>0,'user_id'=>Session::get('user_id'),
'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
);
   $log_insert = $this->log_insert($log_arr);


 
 $flag="1";
 $msg=$title."Update Successfully ";
}else{
  $flag="0";
 $msg=$title."Updation  Failed ";
}
 




 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
}  




public function fetch_po_descrpt_cmp(Request $request){

  $data = DB::table('purchase_orders AS po')
  ->select('po.po_no','po.po_con_no','po.po_amount','po.po_description')

  ->where([['po.pod_a_id', $request->po_id],['po.status','=',0]])
  ->get();



 return response()->json($data);







}







public function op_cmplt_po(Request $request)
{

  $fn_strt_time=date('H:i:s');
  $user_session=Session::get('login_session');
$title='';
$title="Po Complete";
$hidden_status= $request->hidden_status;




 
  $upd= DB::table('purchase_orders')->where('pod_a_id', $request->row_id)->update(
    ['actual_cmp_dt' => Carbon::createFromFormat('d-m-Y', $request->actual_cmp_dt)->format('Y-m-d'),
    'actual_cmp_amt' => $request->actual_cmp_amt,
    'cmpltd_by' =>  $request->added_by,
    'status'=>2
 ]);



if($upd==1){


  $log_arr=array('user_session'=>$user_session,'log_date_time'=>date('Y-m-d H:i:s'),'page'=>'project','function'=>'op_cmplt_po',
  'fn_strt_time'=>$fn_strt_time,'fn_end_time'=>date('H:i:s'),'ref_id'=>$request->row_id,'mode'=>0,'user_id'=>Session::get('user_id'),
  'branch_id'=>Session::get('CID'),'company_id'=>Session::get('CID'),'data'=>json_encode($request->all())
  );
     $log_insert = $this->log_insert($log_arr);



 $flag="1";
 $msg=$title." Successfully ";
}else{
  $flag="0";
 $msg=$title." Failed ";
}
 




 


    return response()->json(['flag'=> $flag,'msg'=> $msg]);
  
}








}

