<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\JsonControllers;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/login', function () {
    return view('auth/login');
});




Route::get('/', function () {
    return view('auth/login');
});
Route::get('ctr', [App\Http\Controllers\HomeController::class, 'ctr']);
Auth::routes();
Route::post('/save_table_settings',[App\Http\Controllers\JsonController::class, 'save_table_settings']);

Route::post('/fetch_table_view_json',[App\Http\Controllers\JsonController::class, 'fetch_table_view_json']);
 Route::get('admin/home', [App\Http\Controllers\AdminsController::class, 'adminHome'])->name('admin.home')->middleware('is_admin');

Route::get('/user_group/{id}', [App\Http\Controllers\AdminsController::class, 'user_group']);
Route::get('/user/{id}', [App\Http\Controllers\AdminsController::class, 'user']);
Route::post('/get_menus', [App\Http\Controllers\AdminsController::class, 'get_menus']);
Route::post('/get_all_menus', [App\Http\Controllers\AdminsController::class, 'get_all_menus']);
Route::post('/get_user_menus', [App\Http\Controllers\AdminsController::class, 'get_user_menus']);
Route::post('/op_user_group', [App\Http\Controllers\AdminsController::class, 'op_user_group']);
Route::get('/set_menu/{id}', [App\Http\Controllers\AdminsController::class, 'set_menu']);
Route::post('/op_user', [App\Http\Controllers\AdminsController::class, 'op_user']);
Route::post('/edit_user', [App\Http\Controllers\AdminsController::class, 'edit_user']);
Route::post('/edit_user_group', [App\Http\Controllers\AdminsController::class, 'edit_user_group']);
Route::post('/op_set_menu', [App\Http\Controllers\AdminsController::class, 'op_set_menu']);
Route::post('/get_details_receipt', [App\Http\Controllers\AdminsController::class, 'get_details_receipt']);






Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('c_home', [App\Http\Controllers\HomeController::class, 'c_home'])->name('c_home');



Route::get('/view_pdf/{fname}', [App\Http\Controllers\HomeController::class, 'view_pdf']);


Route::get('/customer/{id}', [App\Http\Controllers\HomeController::class, 'customer_view']);
Route::get('/contractor/{id}', [App\Http\Controllers\HomeController::class, 'contractor']);
Route::get('/supplier/{id}', [App\Http\Controllers\HomeController::class, 'supplier']);
Route::get('/item/{id}', [App\Http\Controllers\HomeController::class, 'item']);
Route::get('/labour_master/{id}', [App\Http\Controllers\HomeController::class, 'labour_master']);
Route::get('/project/{id}', [App\Http\Controllers\HomeController::class, 'project']);
Route::get('/question/{id}', [App\Http\Controllers\HomeController::class, 'question_view']);
Route::get('/project_assign/{id}', [App\Http\Controllers\HomeController::class, 'project_assign']);
Route::get('/contrctr_dash/{id}', [App\Http\Controllers\HomeController::class, 'contrctr_dash']);
Route::get('/bill_submission/{id}', [App\Http\Controllers\HomeController::class, 'bill_submission']);
Route::get('/receipt_payment/{id}', [App\Http\Controllers\HomeController::class, 'receipt_payment']);
Route::get('/transaction/{id}', [App\Http\Controllers\HomeController::class, 'transaction']);
Route::get('/expense_report/{id}', [App\Http\Controllers\HomeController::class, 'expense_report']);
Route::get('/History/{id}', [App\Http\Controllers\HomeController::class, 'History']);
Route::get('/account_get/{id}', [App\Http\Controllers\HomeController::class, 'account_get']);
Route::get('/project_expense_report/{id}', [App\Http\Controllers\HomeController::class, 'project_expense_report']);






Route::post('/fetch_item', [App\Http\Controllers\HomeController::class, 'fetch_item']);
Route::post('/fetch_sup_con', [App\Http\Controllers\HomeController::class, 'fetch_sup_con']);
Route::post('/op_bill_submit', [App\Http\Controllers\HomeController::class, 'op_bill_submit']);
Route::post('/get_bill_for_settle', [App\Http\Controllers\HomeController::class, 'get_bill_for_settle']);
Route::post('/fetch_wo_no', [App\Http\Controllers\HomeController::class, 'fetch_wo_no']);
Route::post('/op_recepit_payment', [App\Http\Controllers\HomeController::class, 'op_recepit_payment']);
Route::post('/fetch_report_all', [App\Http\Controllers\HomeController::class, 'fetch_report_all']);
Route::post('/fetch_lab', [App\Http\Controllers\HomeController::class, 'fetch_lab']);
Route::post('/fetch_exp_report', [App\Http\Controllers\HomeController::class, 'fetch_exp_report']);




Route::post('/edit_pass', [App\Http\Controllers\DataController::class, 'edit_pass']);
Route::post('/op_contct_or_sup', [App\Http\Controllers\DataController::class, 'op_contct_or_sup']);
Route::post('/op_supplier', [App\Http\Controllers\DataController::class, 'op_supplier']);
Route::post('/edit_contr_sup', [App\Http\Controllers\DataController::class, 'edit_contr_sup']);

Route::post('/fetch_po_no', [App\Http\Controllers\DataController::class, 'fetch_po_no']);
Route::post('/fetch_contrctr', [App\Http\Controllers\DataController::class, 'fetch_contrctr']);

Route::post('/fetch_po_descrpt_cmp', [App\Http\Controllers\DataController::class, 'fetch_po_descrpt_cmp']);


Route::post('/op_item_master', [App\Http\Controllers\DataController::class, 'op_item_master']);
Route::post('/edit_item_master', [App\Http\Controllers\DataController::class, 'edit_item_master']);

Route::post('/op_lbr_master', [App\Http\Controllers\DataController::class, 'op_lbr_master']);
Route::post('/edit_lbr_master', [App\Http\Controllers\DataController::class, 'edit_lbr_master']);
Route::post('/get_data', [App\Http\Controllers\DataController::class, 'get_data']);


Route::post('/op_project', [App\Http\Controllers\DataController::class, 'op_project']);
Route::post('/edit_project', [App\Http\Controllers\DataController::class, 'edit_project']);

Route::post('/op_po_assign', [App\Http\Controllers\DataController::class, 'op_po_assign']);
Route::post('/edit_po_assign', [App\Http\Controllers\DataController::class, 'edit_po_assign']);

Route::post('/load_prev_assgns', [App\Http\Controllers\DataController::class, 'load_prev_assgns']);
Route::post('/load_details_pa', [App\Http\Controllers\DataController::class, 'load_details_pa']);


Route::post('/fetch_pa_max_series', [App\Http\Controllers\DataController::class, 'fetch_pa_max_series']);

Route::post('/import_bill', [App\Http\Controllers\DataController::class, 'import_bill']);
Route::post('/op_trans_bill', [App\Http\Controllers\DataController::class, 'op_trans_bill']);
Route::post('/edit_trans_bill', [App\Http\Controllers\DataController::class, 'edit_trans_bill']);

Route::post('/fetch_bill_for_settle', [App\Http\Controllers\DataController::class, 'fetch_bill_for_settle']);
Route::post('/op_save_settlement', [App\Http\Controllers\DataController::class, 'op_save_settlement']);
Route::post('/op_cmplt_po', [App\Http\Controllers\DataController::class, 'op_cmplt_po']);
Route::post('/load_sups', [App\Http\Controllers\DataController::class, 'load_sups']);
Route::post('/load_pdts_sup', [App\Http\Controllers\DataController::class, 'load_pdts_sup']);
Route::post('/fetch_prev_pays_c_bill', [App\Http\Controllers\DataController::class, 'fetch_prev_pays_c_bill']);



Route::post('/fetch_po_no_val', [App\Http\Controllers\DataController::class, 'fetch_po_no_val']);

Route::POST('/get_data', [App\Http\Controllers\PostController::class, 'get_data'])->name('get_data');


Route::get('/commette_member', [App\Http\Controllers\HomeController::class, 'commette_member'])->name('commette_member');
Route::get('/sample', function () {
    return view('sample');
});

/* Route::get('/admins', function () {
    return view('auth/admin_panel');
});

 */







