<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_masters', function (Blueprint $table) {
            $table->increments('log_a_id');
            $table->integer('log_id')->default(0);
            $table->integer('user_session')->default(0);
            $table->date('log_date_time')->nullable();
            $table->string('page',50)->nullable();
            $table->string('function',50)->nullable();
            $table->time('fn_strt_time')->nullable();
            $table->time('fn_end_time')->nullable();
            $table->integer('ref_id')->default(0);
            $table->integer('mode')->default(0)->comment('0=New 1=Edit 2=Delete 3=Rpt_view');
            $table->integer('user_id')->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);






            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_masters');
    }
};
