<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('login_sessions', function (Blueprint $table) {
            $table->id();
            $table->integer('lu_id')->default(0)->unique();
            $table->integer('user_id')->default(0);
            $table->string('user_name',100)->nullable();
            $table->integer('branch_id')->default(0);
            $table->integer('login_sts')->default(0)->comment('0=Logout 1=Login');
            $table->dateTime('login')->nullable();
            $table->dateTime('logout')->nullable();
            $table->string('system_name',100)->nullable();
            $table->dateTime('sys_date')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('login_sessions');
    }
};
