<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_masters', function (Blueprint $table) {
            $table->increments('pay_id');
            $table->integer('party_id')->default(0);
            $table->integer('sub_sua')->default(0);
            $table->integer('bill_id')->default(0);
            $table->integer('type')->default(0);
            $table->double('debit',15,2)->default(0);
            $table->double('credit',15,2)->default(0);
            $table->integer('labour_id')->default(0);
            $table->timestamp('t_date')->nullable();
            $table->integer('added_by')->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->timestamp('added_on')->nullable();
            $table->integer('status')->default(0);



            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_masters');
    }
};
