<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bill_submissons', function (Blueprint $table) {
            $table->increments('b_id');
            $table->integer('po_id')->default(0);
            $table->string('po_no',100)->nullable();
            $table->integer('c_type')->default(0)->comment('0=Contratcor 1=Supplier');
            $table->integer('c_id')->default(0);
            $table->string('c_name',100)->nullable();

            $table->integer('product_id')->default(0);
            $table->date('bill_date')->nullable();
            $table->double('bill_amt',15,2)->default(0);
            $table->date('submsn_date')->nullable();
            $table->text('remark')->nullable();
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->timestamp('added_on')->nullable();
            $table->integer('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bill_submissons');
    }
};
