<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('labour_masters', function (Blueprint $table) {
            $table->increments('lab_id');
            $table->string('lab_name',200)->nullable();
            $table->string('lab_code',20)->nullable();
            $table->integer('section')->default(0);
            $table->integer('added_by')->default(0);
            
            
            $table->timestamp('added_on')->nullable();
            $table->integer('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('labour_masters');
    }
};
