<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item_masters', function (Blueprint $table) {
            $table->increments('product_id');
            $table->string('p_name',200)->nullable();
            $table->integer('cat_id')->default(0);
            $table->string('product_code',200)->nullable();
            $table->string('batch_code',200)->nullable();
            $table->integer('unit')->default(0);
            $table->string('hsn',200)->nullable();
            $table->double('s_rate_1',15,2)->default(0);
            $table->double('s_rate_2',15,2)->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('added_by')->default(0);
            $table->timestamp('added_on')->nullable();


            
            $table->integer('status')->default(0);
           

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_masters');
    }
};
