<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ser_questions', function (Blueprint $table) {
            $table->increments('qst_id');
            $table->string('question',200)->nullable();
            $table->integer('type')->default(0)->comment('1=MAin 2=Sub 3=third sub');
            $table->integer('mq_id')->default(0);
            $table->integer('sbq_id')->default(0);
            $table->integer('status')->default(0);
            $table->integer('order_sts')->default(0);
            $table->integer('added_by')->default(0);
            $table->date('added_on')->nullable();
            $table->string('C_CODE',50)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ser_questions');
    }
};
