<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\contrct_or_sup_masters;
use Illuminate\Support\Facades\DB;
use App\Models\login_session;
use Auth;
use Redirect;
 
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;
    protected $guard = 'contractors';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('guest:contractors')->except('logout');
        
    }


    public function login(Request $request)

    {   
   

        $input = $request->all();

   

        $this->validate($request, [

            'uname' => 'required',

            'password' => 'required',

        ]);

  
        if(auth()->attempt(array('uname' => $input['uname'], 'password' => $input['password'])))

        {
            session()->put('user_id',  auth()->user()->id);
            session()->put('uname',  auth()->user()->uname);
            session()->put('is_admin',  auth()->user()->is_admin);
            session()->put('usergroup',  auth()->user()->ug_id);

            $c_details = DB::table('companysettings')->where('CID', auth()->user()->branch_id)->first();

            session()->put('CID',  $c_details->CID);
            session()->put('CompanyType',  $c_details->CompanyType);
            session()->put('CompanyCode',  $c_details->CompanyCode);
            session()->put('BranchCode',  $c_details->BranchCode);
            session()->put('BranchName',  $c_details->BranchName);
            session()->put('decimal_place',  $c_details->decimal_place);





            $data = new login_session;

            $last_luid = DB::table('login_sessions')->latest('lu_id')->first();
$last_id=1;
if($last_luid){
    $last_id=$last_luid->lu_id+1;
}else{
    $last_id=1;
}
            $data->lu_id=$last_id;
            $data->user_id=auth()->user()->id;
            $data->user_name=auth()->user()->uname;
            $data->branch_id=$c_details->CID;
            $data->login_sts=0;
            

            $data->login=date('Y-m-d H:i:s');

           
            $data->system_name=request()->ip();
           if( $data->save()){

            
            session()->put('login_session',  $data->lu_id);
            session()->put('login_sts',  $data->login_sts);

           }







            
        if (auth()->user()->is_admin == 1) {


           
                return redirect()->route('admin.home');

            }else{

         
             
                return redirect()->route('home');
               
            }


          

        }
        
        
        else{


            
            return redirect()->route('login')
            ->with('error', 'Username And Password Are Wrong.');

            $this->validate($request, [
                'username' => 'required',

                'password' => 'required',
    
            ]);
    
    
          

        
        
         


            //$contrctor_dtls = DB::table('contrct_or_sup_masters')->where([['username', '=',$input['uname']],['pass', '=',$input['password']]])->first();

// if($contrctor_dtls){


//     // session()->put('user_id',  $contrctor_dtls->c_id);
   
//     // session()->put('uname',  $contrctor_dtls->c_name);
//     // session()->put('is_admin', 0);
//     // return redirect()->route('home');
 
// }
// else{


// }
          
           

        }

          

    }




}
