<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\JsonControllers;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/login', function () {


    
    return view('auth/login');
});


Route::get('/', function () {
    return view('auth/key_reg');
});

Auth::routes();
Route::post('/save_table_settings',[App\Http\Controllers\JsonController::class, 'save_table_settings']);

Route::post('/fetch_table_view_json',[App\Http\Controllers\JsonController::class, 'fetch_table_view_json']);
 Route::get('admin/home', [App\Http\Controllers\AdminsController::class, 'adminHome'])->name('admin.home')->middleware('is_admin');
Route::get('/user_group/{id}', [App\Http\Controllers\AdminsController::class, 'user_group']);
Route::get('/user/{id}', [App\Http\Controllers\AdminsController::class, 'user']);
Route::post('/get_menus', [App\Http\Controllers\AdminsController::class, 'get_menus']);
Route::post('/get_all_menus', [App\Http\Controllers\AdminsController::class, 'get_all_menus']);
Route::post('/get_user_menus', [App\Http\Controllers\AdminsController::class, 'get_user_menus']);
Route::post('/op_user_group', [App\Http\Controllers\AdminsController::class, 'op_user_group']);
Route::get('/set_menu/{id}', [App\Http\Controllers\AdminsController::class, 'set_menu']);
Route::post('/op_user', [App\Http\Controllers\AdminsController::class, 'op_user']);
Route::post('/edit_user', [App\Http\Controllers\AdminsController::class, 'edit_user']);
Route::post('/edit_user_group', [App\Http\Controllers\AdminsController::class, 'edit_user_group']);
Route::post('/op_set_menu', [App\Http\Controllers\AdminsController::class, 'op_set_menu']);

//Route::post('/edit_user_group', [App\Http\Controllers\PostController::class, 'index']);






Route::get('/branch_master/{id}', [App\Http\Controllers\HomeController::class, 'branch_master']);
Route::get('/employee_master/{id}', [App\Http\Controllers\HomeController::class, 'employee_master']);
Route::get('/state_master/{id}', [App\Http\Controllers\HomeController::class, 'state_master']);
Route::get('/district_master/{id}', [App\Http\Controllers\HomeController::class, 'district_master']);
Route::get('/setting_master/{id}', [App\Http\Controllers\HomeController::class, 'setting_master']);
Route::get('/leave_master/{id}', [App\Http\Controllers\HomeController::class, 'leave_master']);
Route::get('/designation_master/{id}', [App\Http\Controllers\HomeController::class, 'designation_master']);
Route::get('/department_master/{id}', [App\Http\Controllers\HomeController::class, 'department_master']);
Route::get('/section_master/{id}', [App\Http\Controllers\HomeController::class, 'section_master']);
Route::get('/schedule_master/{id}', [App\Http\Controllers\HomeController::class, 'schedule_master']);
Route::get('/punching_master/{id}', [App\Http\Controllers\HomeController::class, 'punching_master']);
Route::get('/holiday_schedule/{id}', [App\Http\Controllers\HomeController::class, 'holiday_schedule']);
Route::get('/holidays', [App\Http\Controllers\HomeController::class, 'holidays']);
Route::get('/punch_report/{id}', [App\Http\Controllers\HomeController::class, 'punch_report']);
Route::get('/barcode', [App\Http\Controllers\HomeController::class, 'barcode']);
Route::get('/month_atten/{id}', [App\Http\Controllers\HomeController::class, 'month_atten']);
Route::get('/excel_upload/{id}', [App\Http\Controllers\HomeController::class, 'excel_upload']);
Route::POST('import_emp_excel', [App\Http\Controllers\HomeController::class, 'import_emp_excel']);
Route::get('/manual_punch/{id}', [App\Http\Controllers\HomeController::class, 'manual_punch']);
Route::get('/adv_collection/{id}', [App\Http\Controllers\HomeController::class, 'adv_collection']);
Route::get('/inc_collection/{id}', [App\Http\Controllers\HomeController::class, 'inc_collection']);
Route::get('/SalaryPrepration/{id}', [App\Http\Controllers\HomeController::class, 'SalaryPrepration']);
Route::get('/month_atten_ex/{id}', [App\Http\Controllers\HomeController::class, 'month_atten_ex']);
Route::get('/SalaryPrepration2/{id}', [App\Http\Controllers\HomeController::class, 'SalaryPrepration2']);
Route::get('/Salary_report/{id}', [App\Http\Controllers\HomeController::class, 'Salary_report']);
Route::get('/month_atten_hp/{id}', [App\Http\Controllers\HomeController::class, 'month_atten_hp']);
Route::get('/bank_master/{id}', [App\Http\Controllers\HomeController::class, 'bank_master']);
Route::get('/SalaryPrepration_hp/{id}', [App\Http\Controllers\HomeController::class, 'SalaryPrepration_hp']);



Route::get('/viw_employee/{emp_id}', [App\Http\Controllers\HomeController::class, 'viw_employee']);




Route::POST('/fetch_emp_cat', [App\Http\Controllers\PostController::class, 'fetch_emp_cat'])->name('fetch_emp_cat');
Route::POST('/get_data_shdl', [App\Http\Controllers\PostController::class, 'get_data_shdl'])->name('get_data_shdl');



Route::POST('/verify_reg', [App\Http\Controllers\PostController::class, 'index'])->name('index');


Route::POST('/get_data', [App\Http\Controllers\PostController::class, 'get_data'])->name('get_data');
Route::POST('/store_data', [App\Http\Controllers\PostController::class, 'store_data'])->name('store_data');

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/customer/{id}', [App\Http\Controllers\HomeController::class, 'customer_view']);


Route::get('/commette_member', [App\Http\Controllers\HomeController::class, 'commette_member'])->name('commette_member');
Route::get('/sample', function () {
    return view('sample');
});




/* Route::get('/admins', function () {
    return view('auth/admin_panel');
});

 */







