<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_salary_details', function (Blueprint $table) {
            $table->increments('spd_id');


            $table->integer('sp_id');
            $table->string('emp_name')->nullable();
            $table->string('emp_id')->nullable();
            $table->integer('Monthly')->default(0);

            $table->double('bsalary',15,2)->default(0);
            $table->double('gwday',15,2)->default(0);
            $table->double('gsalary',15,2)->default(0);
            $table->double('ot_wage',15,2)->default(0);
            $table->double('ot_day',15,2)->default(0);
            $table->double('incentive',15,2)->default(0);
            $table->double('tot_addon',15,2)->default(0);
            $table->double('deduction',15,2)->default(0);
            $table->double('tsalary',15,2)->default(0);
            $table->double('payable',15,2)->default(0);
            $table->double('advance',15,2)->default(0);
            $table->double('advance_adj',15,2)->default(0);
            $table->integer('npayable')->default(0);
        

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_salary_details');
    }
};
