<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_salary_masters', function (Blueprint $table) {
            $table->increments('sp_id');
            $table->date('sal_month')->nullable();
            $table->double('sal_tot_day',15,2)->default(0);
            $table->integer('sal_sunday')->default(0);
            $table->double('sal_holiday',15,2)->default(0);
            $table->double('sal_work_day',15,2)->default(0);
            $table->double('tbsalary',15,2)->default(0);
            $table->double('tgsalary',15,2)->default(0);
            $table->double('tot_wage',15,2)->default(0);
            $table->double('tincentive',15,2)->default(0);
            $table->double('ttot_addon',15,2)->default(0);
            $table->double('tdedection',15,2)->default(0);
            $table->double('ttsalary',15,2)->default(0);
            $table->double('tpayable',15,2)->default(0);
            $table->double('tadvance',15,2)->default(0);
            $table->double('tadvance_adj',15,2)->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->integer('added_by')->default(0);
            $table->date('added_on')->nullable();




            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_salary_masters');
    }
};
