<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_daily_attncs', function (Blueprint $table) {
            $table->id();
            $table->integer('at_id')->default(0);
            $table->string('emp_id',100)->default(0);
            $table->time('in_time')->default(0);
            $table->time('out_time')->default(0);
            $table->time('ot')->default(0);
            $table->double('ot_wage',15,2)->default(0);
            $table->date('entry_date')->nullable();
            $table->integer('atn_type')->default(0);
            $table->integer('status')->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->integer('added_by')->default(0);
            $table->dateTime('sys_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_daily_attncs');
    }
};
