<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_barcode_masters', function (Blueprint $table) {
            $table->increments('bt_id');
            $table->text('header')->nullable();
            $table->text('footer')->nullable();
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->integer('status')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_barcode_masters');
    }
};
