<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_attendances', function (Blueprint $table) {
            $table->id();
            $table->integer('at_id')->default(0);
            $table->string('emp_id',100)->default(0);
            $table->integer('schdl_id')->default(0);
            $table->date('entry_date')->nullable();
            $table->time('p_time')->default(0);
            $table->string('remarks',200)->default(0);
            $table->integer('flag')->default(0)->comment("0=IN 1=OUT");
            $table->integer('status')->default(0);
            $table->integer('branch_id')->default(0);
            $table->integer('company_id')->default(0);
            $table->integer('added_by')->default(0);
            $table->dateTime('sys_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_attendances');
    }
};
