<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payroll_details_add', function (Blueprint $table) {
            $table->id();
            $table->string('pay_id',20)->default('')->unique();
            $table->string('emp_id',20)->default('');
            $table->integer('branch_id')->default(0);
            $table->integer('desg')->default(0);
            $table->integer('dept')->default(0);
            $table->integer('sect')->default(0);
            $table->time('w_hrs')->default(0);
            $table->double('basic',15,2)->default(0);
            $table->integer('dafromda')->default(0);
            $table->double('DA',15,2)->default(0);
            $table->string('pf_ac_no',100)->default('');
            $table->string('esi_ac_no',100)->default('');
            $table->string('lwf_ac_no',100)->default('');
            $table->integer('pay_type')->default(0);
            $table->string('bank_name',100)->default('');
            $table->string('bank_ac_name',100)->default('');
            $table->string('bank_ac_no',100)->default('');
            $table->string('bank_ifsc',100)->default('');

            $table->integer('company_id')->default(0);
            





            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_details');
    }
};
