<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_punch_settings', function (Blueprint $table) {
            $table->increments('p_id');
            $table->integer('punching_gap')->default(0);
            $table->double('full_min_hr',4,2)->default(0);
            $table->double('full_max_hr',4,2)->default(0);
            $table->double('half_min_hr',4,2)->default(0);
            $table->double('half_max_hr',4,2)->default(0);
            $table->double('quater_min_hr',4,2)->default(0);
            $table->double('quater_max_hr',4,2)->default(0);
        
            $table->integer('company_id')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_punch_settings');
    }
};
