<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prl_state_masters', function (Blueprint $table) {
            $table->increments('state_id');
            $table->string('state_name', 100)->nullable();
            $table->string('state_code', 5)->nullable();
            $table->integer('state_code_number')->default(0);

            $table->double('state_dd_amount',15,2)->default(0);
            $table->string('country', 100)->nullable();
           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prl_state_masters');
    }
};
