<?php

namespace App\Imports;

use App\Models\prl_employee_master;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Redirect;
class EmployeeImport implements ToModel,WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null


    */


    public function  __construct($branch_id)
    {
        $this->branch_id= $branch_id;
    }
    public function model(array $row)
    {
        $gender=0;
$emp_id='';
        $c_details = DB::table('prl_companysettings')->where('CID',$this->branch_id)->first();
        $b_details = DB::table('prl_branch_masters')->where('BranchID',$this->branch_id )->first();
   $pattern= $c_details->CompanyCode.$b_details->BranchCode;
   $CID=$c_details->CID;
      
   $emp_s = DB::select( "SELECT emp_id FROM prl_employee_masters WHERE emp_id like '$pattern%' ORDER BY LENGTH(emp_id) DESC , emp_id  DESC  LIMIT 1") ;

$s=$emp_s[0]->emp_id;


if($s==""){
    $emp_id= $pattern.str_pad('1',4,'0',STR_PAD_LEFT);
}
else{

    $split=@explode($pattern,$s);
    $last=$split[1]; $last++;
    $s=str_pad($last,4,"0",STR_PAD_LEFT);
    $emp_id= $pattern.$s;

}
$dob = Carbon::createFromFormat('d/m/Y',$row['dob'])->format('Y-m-d');
$doj = Carbon::createFromFormat('d/m/Y',$row['doj'])->format('Y-m-d');


if($row['gender']=='M' ||$row['gender']=='m' ){
    $gender=0;
}
else if($row['gender']=='F' || $row['gender']=='f'){
    $gender=1;
}


$count= DB::table('prl_employee_masters')->where('emp_code',$row['emp_code'])->count();




if($count==0){


        return new prl_employee_master([
            'emp_id'=>$emp_id,
            'emp_name'=>$row['name'],
            'guardian'=>$row['guardian'],
            'gender'=>$gender,
            'addres'=>$row['addres'],
            'country'=>103,
            'state'=>10,
            'district'=>4,
            'emp_code'=>$row['emp_code'],
            'serial_no'=>$row['serial_no'],
            'mach_code'=>$row['mach_code'],
            'phone'=>$row['phone'],
            'blood'=>$row['blood'],
            'dob'=>$dob,
            'doj'=>$doj,
            'religion'=>$row['religion'],
            'pin'=>$row['pin'],
            'phone2'=>$row['phone2'],
          
            'branch_id'=>$this->branch_id,
            'company_id'=>$CID

        ]);

  

    }




    }






    public function rules(): array
    {
        return [
          
            'emp_code' =>  'unique|prl_employee_master:emp_code'
          
        ];
    }








}
