
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Map Routes</title>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <style>
        #map {
            height: 600px;
            width: 100%;
        }
    </style>
</head>
<body>
    <div id="map"></div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
</body>
</html>
<script>
$(document).ready(function() {
    // Initialize the map
    var map = L.map('map').setView([0, 0], 2);

    // Set up the OSM layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
    }).addTo(map);

    // Fetch the data from the PHP script
    $.getJSON("fetch_data.php", function(data) {
        var latlngs = [];

        // Loop through the data to create an array of LatLng objects
        $.each(data, function(index, value) {
            latlngs.push([value.latitude, value.longitude]);
        });

        // Create a polyline using the array of LatLng objects
        var polyline = L.polyline(latlngs, {color: 'blue'}).addTo(map);

        // Zoom the map to the polyline
        map.fitBounds(polyline.getBounds());
    });
});
</script>
