
$.widget('custom.tableAutocomplete', $.ui.autocomplete, {
    options: {
        open: function (event, ui) {
            // Hack to prevent a 'menufocus' error when doing sequential searches using only the keyboard
            $('.ui-autocomplete .ui-menu-item:first').trigger('mouseover');
        },
        focus: function (event, ui) {
            event.preventDefault();
        }
    },
    _create: function () {
        this._super();
        // Using a table makes the autocomplete forget how to menu.
        // With this we can skip the header row and navigate again via keyboard.
        this.widget().menu("option", "items", ".ui-menu-item");
    },
    _renderMenu: function (ul, items) {
        var self = this;
        var $table = $('<table class="table-autocomplete">'),
            $thead = $('<thead>'),
            $headerRow = $('<tr>'),
            $tbody = $('<tbody>');

        $.each(self.options.columns, function (index, columnMapping) {
           // $('<th>').css("");
            $('<th style="width:'+columnMapping.width+' !important;">').text(columnMapping.title).appendTo($headerRow);
        });

        $thead.append($headerRow);
        $table.append($thead);
        $table.append($tbody);

        ul.html($table);

        $.each(items, function (index, item) {
            self._renderItemData(ul, ul.find("table tbody"), item);
        });
    },
    _renderItemData: function (ul, table, item) {
        return this._renderItem(table, item).data("ui-autocomplete-item", item);
    },
    _renderItem: function (table, item) {
        var self = this;
        var $tr = $('<tr class="ui-menu-item" role="presentation">');

        $.each(self.options.columns, function (index, columnMapping) {
            var cellContent = !item[columnMapping.field] ? '' : item[columnMapping.field];
            $('<td>').text(cellContent).appendTo($tr);
        });

        return $tr.appendTo(table);
    }
});


$(function () {

  $(document).on('keyup', '.item_code', function (e) {
 	var pat =$(this).val();
var tr_id = $(this).closest('tr').attr('id');


    $(this).tableAutocomplete({
appendTo:".autocomplete_result",
position: { my: "left top", at: "center  top", of: ".autocomplete_result" },
        source:  function( request, response ) {
$.ajax({
url: "fetch_item_master_purchase_return.php",
type: "POST",
data: {
ename: $.trim(pat) ,
s_id:$.trim($('#s_id').val()),
supplier_purchased:$('#supplier_purchased:checked').length

},
dataType: "json",
success: function( data ) {

response( $.map( data.myData, function( item ) {
return {
label: item.label,
value: item.label,
item_kfc_tax: item.item_kfc_tax,
item_gst_tax: item.item_gst_tax,
batch_code: item.batch_code,
product_code: item.product_code,
current_stock: item.current_stock,
item_purchase_price: item.item_purchase_price,
item_hsn_sac: item.item_hsn_sac,
item_id: item.item_id,
batch_name: item.batch_name,
brand_name: item.brand_name,
mod_name: item.mod_name,
m_name: item.m_name,
color_name: item.color_name
}
}));
}
});
},
        columns: [{
            field: 'product_code',
            title: 'Design Code',
            width: '20%'
        }, {
            field: 'batch_code',
            title: 'Item Code',
            width: '10%'
        }, {
            field: 'batch_name',
            title: 'Item Name',
            width: '60%'
        }, {
            field: 'current_stock',
            title: 'Stock',
            width: '10%'
        }],
         change : function(event, ui) {
                	if (ui.item=='')
							  { 				
								alert("Not found");
								$(this).val('');
								$(this).focus();
							
							    $('#'+tr_id+' .item_code').attr("item_id",'');	
								$('#'+tr_id+' .item_code').attr("kfc",'');
								$('#'+tr_id+' .item_code').attr("item_gst_tax",'');
								$('#'+tr_id+' .item_code').attr("current_stock",'');
																
							  }	
           },
               open: function(event, ui) {}, 
        select: function (event, ui) {
            if (ui.item.value!=undefined)
							  {
							  	
							  	if($('.item_code').is('[item_id="'+ui.item.item_id+'"]')==false){
							  			
							  		$('#'+tr_id+' .cat_name').val(ui.item.value);						
							  		$('#'+tr_id+' .product_qty').val(1);						
							  		$('#'+tr_id+' .item_code').val(ui.item.batch_code);						
									if($('#invoice_type').val()==1)
									{
										$('#'+tr_id+' .item_code').attr("kfc",0);
									}
									else
									{
									$('#'+tr_id+' .item_code').attr("kfc",ui.item.item_kfc_tax);
									}
									
									$('#'+tr_id+' .item_code').attr("item_gst_tax",ui.item.item_gst_tax);
									$('#'+tr_id+' .item_code').attr("current_stock",ui.item.current_stock);
									$('#'+tr_id+' .item_code').attr("item_id",ui.item.item_id);
									$('#'+tr_id+' .hsn_code').val(ui.item.item_hsn_sac);
									$('#'+tr_id+' .item_code').attr("rate",ui.item.item_purchase_price);

$('#'+tr_id+' .brand_name').val(ui.item.brand_name);
$('#'+tr_id+' .mod_name').val(ui.item.mod_name);
$('#'+tr_id+' .m_name').val(ui.item.m_name);
$('#'+tr_id+' .color_name').val(ui.item.color_name);
$('#'+tr_id+' .last_prodcut_rate').val(ui.item.item_purchase_price);

							
									
										addrow(tr_id);
										chenge_row(tr_id,'0');
										
							  	}else{ 
							  		$('#'+tr_id+' .cat_name').val(''); 
							  		alert("Item Name Already Exist");
							  		$(this).val('');
									$(this).focus();
									 $('#'+tr_id+' .item_code').attr("current_stock",'');
									 $('#'+tr_id+' .item_code').attr("kfc",'');
									 $('#'+tr_id+' .item_code').attr("item_id",'');
									 $('#'+tr_id+' .item_code').attr("item_gst_tax",'');
									$(this).attr("item_hsn_sac",'');
									
								    $('#'+tr_id+' .item_code').attr("rate",'');
							  	}
						
					
							}else{
								alert("Not found");
								$(this).val('');
								$(this).focus();
								 $('#'+tr_id+' .item_code').attr("current_stock",'');
									 $('#'+tr_id+' .item_code').attr("kfc",'');
									 $('#'+tr_id+' .item_code').attr("item_id",'');
									 $('#'+tr_id+' .item_code').attr("item_gst_tax",'');
									$(this).attr("item_hsn_sac",'');
									
								    $('#'+tr_id+' .item_code').attr("rate",'');
							}
				
            return false;
        }
    });
    });


});



 $(document).on('keyup', '#s_name', function (e) {
	
		s_name = $.trim($(this).val()); 
	 
 if(s_name!="" && s_name!="=")
 { 
    $(this).tableAutocomplete({
		appendTo:".autocomplete_result",
        source:  function( request, response ) {
$.ajax({
url: "fetch_supplier_master.php",
type: "POST",
data: {
ename: s_name,
filter_status: $.trim($('#filter_status').val()) },
dataType: "json",
success: function( data ) {

response( $.map( data.myData, function( item ) {
return {
cus_name: item.cus_name,
customer_id: item.customer_id,
label: item.s_name,
value: item.s_name2,
state: item.state,
phone: item.phone,
gstin: item.gstin,
supplier_state: item.supplier_state, 
n1: item.s_id,
b2b: item.b2b,
b2bstr: item.b2bstr
}
}));
}
});
},
        columns: [{
            field: 'cus_name',
            title: 'Supplier Name',
            width: '70%'
        }, {
            field: 'gstin',
            title: 'GST',
            width: '30%'
        }, {
            field: 'b2bstr',
            title: 'Type',
            width: '30%'
        }, {
            field: 'phone',
            title: 'Phone',
            width: '30%'
        }],
         change : function(event, ui) {
                	 if ( !ui.item ) 
									 { 
								if($(this).val()!="")
								{
									call_alert_msg_div("Not Valid Customer",1);	
								}
									
									$('#s_id').val('0');
									 }
									 else
									 {
if(ui.item.state==$('#CGST_STATE').val())
{
$('#state_type').val('1');
}
else
{
$('#state_type').val('0');	
}	
load_cgst_values();									 }
           },
               open: function(event, ui) {}, 
        select: function (event, ui) {
            if (ui.item != undefined) {	

						$(this).val(ui.item.value);
						$('#s_id').val(ui.item.n1);					
						$('#invoice_type').val(ui.item.b2b);
						$('#gstin_no').html(ui.item.gstin);
						$('#bill_type').html(ui.item.b2bstr); 
						
if(ui.item.state==$('#CGST_STATE').val())
{
$('#state_type').val('1');
}
else
{
$('#state_type').val('0');	
}
load_cgst_values();						  
						
						fetch_opening_bal(ui.item.n1);
            }
            return false;
        }
    }); 
	
 }
	 
 });


function load_cgst_values()
{
	$('.tot_tr').each(function(index, element) {
	tr_id = $(this).closest('tr').attr('id');	
	gst = parseFloat($('#'+tr_id+' .tax_master').val());
			
	if($('#state_type').val()==1)
	{
	cgst_tax=gst/2;
	igst_tax=0;
	}
	else
	{
	cgst_tax=0;
	igst_tax=gst;	
	}
	
	
	$('#'+tr_id+' .product_csgst_per').val(cgst_tax);
	$('#'+tr_id+' .product_ssgst_per').val(cgst_tax);
	$('#'+tr_id+' .product_isgst_per').val(igst_tax);
	chenge_row(tr_id,'0');	

	});	
}
	


 $(document).on('keyup keydown ', '.tax_master', function (e) {
   var color= $(this).val();
$(this).autocomplete({
              
          autoFocus: true,
            source: function( request, response ) {
              $.ajax({
                url: "fetch_tax_master.php",
                type: "POST",
                data: {
                  ename:color},
                dataType: "json",
                success: function( data ) {
                  response( $.map( data.myData, function( item ) {
                    return {
                      label: item.tax_per,
                      value: item.tax_per,                     
                      n1: item.tax_id,
                      tax_name: item.tax_name
                    }
                  }));
                }
              });
              
            },
            change : function(event, ui) {
                 if ( !ui.item )
                  { 
                  $(this).focus();
                   $(this).val('');
                   $(this).attr("tax_id","");
                   $(this).css('background-color','#FFFFFF');
                  } 
               
           },
            select: function (event, ui) {            
            $(this).val(ui.item.value);           
            $(this).attr("tax_id",ui.item.n1);
			tr_id = $(this).closest("tr").attr('id');
			gst = parseFloat(ui.item.value);
			
if($('#state_type').val()==1)
{
cgst_tax=gst/2;
igst_tax=0;
}
else
{
cgst_tax=0;
igst_tax=gst;	
}


$('#'+tr_id+' .product_csgst_per').val(cgst_tax);
$('#'+tr_id+' .product_ssgst_per').val(cgst_tax);
$('#'+tr_id+' .product_isgst_per').val(igst_tax);
chenge_row(tr_id,'0');			
	return false;
          
        }
        });
        });
		





function save_dyn_measurement(m_name,pass_id){
	if($.trim(m_name)!="")
	{
$.ajax({
                type: 'POST',
                url: 'dyn_measurement_master.php',
                data: {
           m_name: $.trim(m_name)    
           
                },
                error: function (request, error) {
                    alert("Please Wait, Loading...");
                },
                success: function (response) {                    
            var ResArr = response.split('`~`'); 
            if(ResArr[0]=='1')
            {
           // $('#'+pass_id).val(mod_name);
            $('#'+pass_id).attr("m_id",ResArr[1]);  
            }
            else
            {
          //  $('#'+pass_id).val('');
            $('#'+pass_id).attr("m_id",""); 
              
            }
        }
          
     });    
	}
  
}



function customer_bill_settings(state,invoice_type,invoice_typestr,gstin_no)
{
$('#invoice_type').val(invoice_type);
$('#gstin_no').html(gstin_no);
$('#bill_type').html(invoice_typestr); 

if(state==$('#CGST_STATE').val())
{
$('#state_type').val('1');
}
else
{
$('#state_type').val('0');	
}		
	
}



  
function add_grid(){ 
	count=parseInt($('#dyn_table_id').attr('nbr'))+1;
	$('#dyn_table_id').attr('nbr',count);
	tr_id="'tab_"+count+"'";
	
	xxx="'0'";
	
	
tab_ht='<tr id="tab_'+count+'" class="tot_tr">';
          tab_ht+='<td></td>';
          tab_ht+='<td> <input  type="text" class="form-control input-sm   input_next item_code"   old_row="0"   item_gst_tax="0" kfc="0"></td>';
          tab_ht+='<td> <input  readonly type="text" class="form-control input-sm  cat_name "  cat_id="0" ></td>';
		  
		  tab_ht+='<td> <input  readonly type="text" class="form-control input-sm  brand_name"  brand_id="0" ></td>';
		  
		  tab_ht+='<td> <input readonly type="text" class="form-control input-sm  mod_name"   mod_id="0" ></td>';
		   
		  tab_ht+='<td> <input  readonly type="text" class="form-control input-sm  m_name" m_id="0" ></td>'; 
			 
		  tab_ht+='<td> <input readonly  type="text" class="form-control input-sm  color_name" color_id="0"  ></td>';
			   
		  tab_ht+='<td> <input readonly  type="text" class="form-control input-sm hsn_code" ></td>';  
 
          tab_ht+='<td> <input          type="text" class="form-control input-sm text-right input_next product_qty" onkeypress="return isNumber(event, this.value);"  onkeyup="chenge_row('+tr_id+','+xxx+');"  value="0"   onfocus="this.select();"></td>';
		  
		   tab_ht+='<td><input readonly type="text" class="form-control input-sm text-right last_prodcut_rate"  value="0" ></td>';
		  
          tab_ht+='<td> <input   type="text" class="form-control input-sm text-right prodcut_rate input_next "  onkeypress="return isNumber(event, this.value);"    onkeyup="chenge_row('+tr_id+','+xxx+');"  onfocus="this.select();"  value="0" ></td>';
		  
		   tab_ht+='<td class="d-none-td" > <input readonly type="text" class="form-control input-sm text-right product_gross" ></td>';
		  
		   tab_ht+='<td > <input  onkeypress="return isNumber(event, this.value);"    onkeyup="change_discount_per('+tr_id+');"  onfocus="this.select();"  type="text" class="form-control input-sm text-right input_next product_discount_per"  value="0"  ></td>';
		  
		  
		   tab_ht+='<td > <input   onkeypress="return isNumber(event, this.value);"    onkeyup="change_discount('+tr_id+');"  onfocus="this.select();"  type="text" class="form-control input-sm text-right input_next product_discount"  value="0"  ></td>';
		   
		    tab_ht+='<td> <input readonly type="text" class="form-control input-sm text-right product_taxable" value="0"></td>';
		  
		    tab_ht+='<td><input type="text" class="form-control input-sm text-right input_next tax_master"   onkeypress="return isNumber(event, this.value);"      onfocus="this.select();"  value="0" ></td>';	
			
			  tab_ht+='<td><input readonly type="text" class="form-control text-right input-sm tax_amt"  value="0" ></td>';
			  
			    tab_ht+='<td><input readonly type="text" class="form-control input-sm  text-right product_cost" value="0" ></td>';
		 
         
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_csgst_per" value="0" ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_csgst_amt" ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_ssgst_per"  value="0"  ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_ssgst_amt" ></td>';
		   tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_isgst_per"  value="0" ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_isgst_amt" ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_kfc_per"  value="0" ></td>';
          tab_ht+='<td class="d-none-td"> <input readonly type="text" class="form-control input-sm text-right product_kfc_amt" ></td>';
          tab_ht+='<td > <input readonly type="text" class="form-control input-sm text-right product_total" value="0" ></td>';
          tab_ht+='<td> <i class="fa fa-trash" batch_code="" batch_id="" onClick="remove_row(this);" style="cursor: pointer;"></i></td>';
        tab_ht+=' </tr>';
        $('#dyn_table_id > tbody').append(tab_ht);
        numbering();
 tot_add();
}
function numbering(){
	$('#dyn_table_id > tbody >tr >td:first-child').each(function(i) {
        $(this).html(i+1);
    });
}


function remove_row(the){
if($(the).closest("tr").is(":last-child")){
	alert("You Can't Remove Last Row");
}else{
	$(the).closest("tr").remove();
	numbering();
	 tot_add();
}
}



function chenge_disc() {
		disc=$('#disc_percentage').val();
		   if($.trim(disc)=='')disc=0;
	$('.tot_tr').each(function() {
		tr_id=$(this).attr('id');
		if($(this).find('.product_qty').val()!=''){
			chenge_row(tr_id,'0');
	}
});
	
}


function validate_row(tr_id) { 

	current_stock=$('#'+tr_id+' .item_code').attr('current_stock');
	quantity=$('#'+tr_id+' .product_qty').val();
	if((parseInt(current_stock) < parseInt(quantity)) || quantity=='' || parseInt(quantity)==0){
		alert('Current Stock is '+current_stock+', Enter Correct Quantity');
		$('#'+tr_id+' .product_qty').val('1');
		$('#'+tr_id+' .product_qty').focus();

	}
	
	}
	
	
	function  change_discount_per(tr_id)	
	{
		console.log("change_discount_per ");
	product_qty=$('#'+tr_id+' .product_qty').val();	
	prodcut_rate=$('#'+tr_id+' .prodcut_rate').val();
	product_discount_per=$('#'+tr_id+' .product_discount_per').val();
	
	product_discount = (parseFloat(product_qty) * parseFloat(prodcut_rate) * parseFloat(product_discount_per))/100;	
	
if(Number.isNaN(product_discount))
{
product_discount=0;	
}
	
	$('#'+tr_id+' .product_discount').val(product_discount.toFixed(2));
	
	
	chenge_row(tr_id,'0');	
	}
		  
	function  change_discount(tr_id){
	
	product_qty=$('#'+tr_id+' .product_qty').val();	
	prodcut_rate=$('#'+tr_id+' .prodcut_rate').val();
	product_discount=$('#'+tr_id+' .product_discount').val();	
	
	if(Number.isNaN(product_discount))
{
product_discount=0;	
}
	
	product_discount_per = (parseFloat(product_discount) * 100)/(parseFloat(product_qty) * parseFloat(prodcut_rate));
	
	$('#'+tr_id+' .product_discount_per').val(product_discount_per.toFixed(7));
	
	chenge_row(tr_id,'0');		
	}
	
	
	
	
function chenge_row(tr_id,xxx) { 
	
	if($.trim($('#'+tr_id+' .cat_name').val())!=''){
	current_stock=$('#'+tr_id+' .item_code').attr('current_stock');

	quantity=$('#'+tr_id+' .product_qty').val();
	
	sales_rates=$('#'+tr_id+' .prodcut_rate').val();
	product_discount=$('#'+tr_id+' .product_discount').val();
	 
	 gst_tax=parseFloat($('#'+tr_id+' .product_csgst_per').val());
	 igst_tax=parseFloat($('#'+tr_id+' .product_isgst_per').val());
	kfc_per_attr=parseFloat($('#'+tr_id+' .item_code').attr('kfc'));
	
	 if($.trim(quantity)=='') quantity=0; 
	 if($.trim(sales_rates)== '')sales_rates=0;
	 if($.trim(gst_tax)=='')gst_tax=0;
	 if($.trim(igst_tax)=='')igst_tax=0;
	 if($.trim(kfc_per_attr)=='')kfc_per_attr=0;
	
	 
	
	gross=quantity*sales_rates;
	
	taxable = gross - product_discount;
	
	$('#'+tr_id+' .product_gross').val(gross);
	
	 
	 if($('#state_type').val()==1)
	{
	 total_gst = (gst_tax * 2);	
	 total_igst =0;
	}
	else
	{
	 total_gst =0;	
	 total_igst =igst_tax;	
	}	 

	total_taxes=parseFloat(kfc_per_attr)+parseFloat(total_gst)+parseFloat(total_igst);	
	
	$('#'+tr_id+' .product_taxable').val(taxable);
 	
	item_gst_tax=parseFloat(gst_tax);
	item_igst_tax=parseFloat(igst_tax);
	
	kfc_per=parseFloat(kfc_per_attr)/100;
	gst=parseFloat(item_gst_tax)/100;
	igst=parseFloat(item_igst_tax)/100;	 
	
	
	amt=gst*taxable;
	amti=igst*taxable;
	$('#'+tr_id+' .product_csgst_amt').val(amt);
	$('#'+tr_id+' .product_ssgst_amt').val(amt);
	$('#'+tr_id+' .product_isgst_amt').val(amti);
	
	kfc_amt=kfc_per*taxable;
	
	$('#'+tr_id+' .product_kfc_amt').val(kfc_amt);
	
	total_tax_amt= parseFloat(amt)+parseFloat(amt)+parseFloat(amti)+parseFloat(kfc_amt);
	
	$('#'+tr_id+' .tax_amt').val(total_tax_amt.toFixed(2));
	
	total=parseFloat(taxable)+parseFloat(total_tax_amt);
	
	product_cost = parseFloat(total)/parseFloat(quantity);
	
	$('#'+tr_id+' .product_cost').val(product_cost.toFixed(2));
	
	$('#'+tr_id+' .product_total').val(total.toFixed(2));	
	
	
	 tot_add();
	 
	
	 
	}
}



  function addrow(tr_id){  
	if($.trim($('#'+tr_id+' .cat_name').val())!=''){
	gst=$('#'+tr_id+' .item_code').attr('item_gst_tax');
	
	
	
	quantity=$('#'+tr_id+' .product_qty').val();
	
	sales_rates=$('#'+tr_id+' .item_code').attr('rate');
	$('#'+tr_id+' .prodcut_rate').val(sales_rates);
	dis_per=$('#disc_percentage').val();
	if(dis_per=='')dis_per=0;
	disc_percentage=parseFloat(dis_per)/100; 
	disc=quantity*sales_rates*disc_percentage;
	
if(Number.isNaN(disc))
{
disc=0;	
}
	
	$('#'+tr_id+' .product_discount').val(disc.toFixed(2));
	
	gross=quantity*sales_rates;
	$('#'+tr_id+' .product_gross').val(gross.toFixed(2));
	
	
	
	taxable=(quantity*sales_rates)-disc; 
	$('#'+tr_id+' .product_taxable').val(taxable.toFixed(2));

	if($('#state_type').val()==1)
	{
	cgst_tax=gst/2;
	igst_tax=0;
	}
	else
	{
	cgst_tax=0;
	igst_tax=gst;	
	}
	
	
	$('#'+tr_id+' .product_csgst_per').val(cgst_tax);
	$('#'+tr_id+' .product_ssgst_per').val(cgst_tax);
	$('#'+tr_id+' .product_isgst_per').val(igst_tax);
	
	gst=cgst_tax/100;
	amt=gst*taxable;
	
	gsti=igst_tax/100;
	amti=gsti*taxable;
	
	
	$('#'+tr_id+' .product_csgst_amt').val(amt.toFixed(2));
	$('#'+tr_id+' .product_ssgst_amt').val(amt.toFixed(2));
	$('#'+tr_id+' .product_isgst_amt').val(amti.toFixed(2));
	
	
	kfc=$('#'+tr_id+' .item_code').attr('kfc');
	if(kfc=='')kfc=0;
	kfc_per=parseFloat(kfc)/100;
	kfc_amt=kfc_per*taxable;
	$('#'+tr_id+' .product_kfc_per').val(kfc);
	$('#'+tr_id+' .product_kfc_amt').val(kfc_amt.toFixed(2));
	total=taxable+amt+amt+amti+kfc_amt;
	$('#'+tr_id+' .product_total').val(total.toFixed(2));
		
	if($.trim($('#dyn_table_id tr:last-child .item_code').val())!=''){
		add_grid();	
	}
	}

}





function tot_add() {

	   	tot_dis=0;
   		tot_tax_val=0;
		tot_gross=0;
   		tot_cgst=0;
		tot_igst=0;
   		
   		tot_qty=0;
   		grand=0;
	   $('.tot_tr').each(function() { 
    if($(this).find(".product_qty").val()!=''){
  		tot_qty+=parseFloat($(this).find(".product_qty").val());
    }
     if($(this).find(".product_discount").val()!=''){
  		tot_dis+=parseFloat($(this).find(".product_discount").val());
    }
	
	 if($(this).find(".product_gross").val()!=''){
  		tot_gross+=parseFloat($(this).find(".product_gross").val()); 
    }
	
    if($(this).find(".product_taxable").val()!=''){
  		tot_tax_val+=parseFloat($(this).find(".product_taxable").val()); 
    }
    if($(this).find(".product_csgst_amt").val()!=''){
  		tot_cgst+=parseFloat($(this).find(".product_csgst_amt").val());
    }
	 if($(this).find(".product_isgst_amt").val()!=''){
  		tot_igst+=parseFloat($(this).find(".product_isgst_amt").val());
    }
   
    if($(this).find(".product_total").val()!=''){
  		grand+=parseFloat($(this).find(".product_total").val());
    }
    	$('#tot_qty').val(tot_qty.toFixed(0));
    	$('#tot_dis').val(tot_dis);
   		$('#tot_tax_val').val(tot_tax_val.toFixed(2));
   		$('#tot_cgst,#tot_sgst').val(tot_cgst.toFixed(2));
		$('#tot_igst').val(tot_igst.toFixed(2));
		
		$('#tot_gross').val(tot_gross.toFixed(2));
   		
		$('#net').val(grand.toFixed(2));
   		$('#grand').val(grand.toFixed(2));
   		net_totel();

});
}




function net_totel()
{
net = ($('#net').val() =='') ? '0' : $('#net').val();
pack_rate = ($('#pack_rate').val() =='') ? '0' : $('#pack_rate').val();

total=parseFloat(net) + parseFloat(pack_rate);

rounding(total);	
}





function rounding(val)
{
dec = parseFloat(val) - parseFloat(Math.floor(val));	

if(dec<=.50)
{
net_total=Math.floor(val);	
}
else  if(dec>.50)
{
net_total=Math.ceil(val);	
}

$('#total_pay').val(net_total.toFixed(2));

tot_round = ((parseFloat($('#tot_tax_val').val()) + parseFloat($('#tot_igst').val()) + parseFloat($('#tot_cgst').val()) + parseFloat($('#tot_sgst').val()) + parseFloat($('#pack_rate').val())) - parseFloat(net_total)  ).toFixed(2);

$('#tot_rounding').val(tot_round);



}




	


function isNumber(evt, value) {
	
   evt = (evt) ? evt : window.event;
   var k=value.indexOf(".");   
    var charCode = (evt.which) ? evt.which : evt.keyCode;

	if(k==-1)
	{
			if (charCode > 31 && (charCode < 46 || charCode > 57 || charCode==47)) {
				
				return false;
				
			}
			return true;
	}
	else if(k!=-1 && charCode==46)
	{
	return false	
	}
	else
	{
		 if (charCode > 31 && (charCode < 46 || charCode > 57 || charCode==47)) {
				
				return false;
				
			}
			return true;
	}
}

function get_next_invoice_number()
{
$.ajax({
                type: 'POST',
                url: 'get_next_purchase_return_number.php',
                data: {
                   type:1				   
                },
                error: function (request, error) {
                    alert("Please Wait, Loading...");
                },
                success: function (response) {
					 
					$('#invoice_no').val(response);
					
				}
					
		 });		

}






function set_mgstin()
{
var m_state =$('#m_state').val();
 $('#m_gstin').val(m_state);	
}


function fetch_purchase_details(s_invoice_id)
{
	
   	$.ajax({
                type: 'POST',
                url: 'edit_purchase_return_details.php',
                data: {
                    s_invoice_id:s_invoice_id
				   
                },
                error: function (request, error) {
                    alert("Please Wait, Loading...");
                },
                success: function (response) {
					
					  datas=JSON.parse(response);	
					
$.each(datas['myData'], function (key,VALUE) {
$('.tot_tr:last-child').find('.item_code').val(VALUE['batch_code']);
$('.tot_tr:last-child').find('.item_code').attr('current_stock',VALUE['current_stock']);
$('.tot_tr:last-child').find('.item_code').attr('item_id',VALUE['item_id']);
$('.tot_tr:last-child').find('.item_code').attr('s_invoice_d_id',VALUE['s_invoice_d_id']);
$('.tot_tr:last-child').find('.item_code').attr('item_gst_tax',VALUE['item_gst_tax']);
$('.tot_tr:last-child').find('.item_code').attr('kfc',VALUE['kfc']);
$('.tot_tr:last-child').find('.item_code').attr('old_row',1);
$('.tot_tr:last-child').find('.item_code').attr('old_qty',VALUE['old_qty']);


$('.tot_tr:last-child').find('.cat_name').val(VALUE['cat_name']);
$('.tot_tr:last-child').find('.cat_name').attr('cat_id',VALUE['cat_id']);


$('.tot_tr:last-child').find('.brand_name').val(VALUE['brand_name']);
$('.tot_tr:last-child').find('.brand_name').attr('brand_id',VALUE['brand_id']);


$('.tot_tr:last-child').find('.mod_name').val(VALUE['mod_name']);
$('.tot_tr:last-child').find('.mod_name').attr('mod_id',VALUE['mod_id']);

$('.tot_tr:last-child').find('.m_name').val(VALUE['m_name']);
$('.tot_tr:last-child').find('.m_name').attr('m_id',VALUE['m_id']);


$('.tot_tr:last-child').find('.color_name').val(VALUE['color_name']);
$('.tot_tr:last-child').find('.color_name').attr('color_id',VALUE['color_id']);

$('.tot_tr:last-child').find('.hsn_code').val(VALUE['hsn']);

$('.tot_tr:last-child').find('.tax_master').val(VALUE['item_gst_tax']);

$('.tot_tr:last-child').find('.product_qty').val(VALUE['product_qty']);

$('.tot_tr:last-child').find('.last_prodcut_rate').val(VALUE['last_prodcut_rate']);

$('.tot_tr:last-child').find('.prodcut_rate').val(VALUE['product_rate']);
$('.tot_tr:last-child').find('.product_discount_per').val(VALUE['product_discount_per']);
$('.tot_tr:last-child').find('.product_discount').val(VALUE['product_discount']);
$('.tot_tr:last-child').find('.product_gross').val(VALUE['product_gross']);
$('.tot_tr:last-child').find('.product_taxable').val(VALUE['product_taxable']);
$('.tot_tr:last-child').find('.tax_master').val(VALUE['item_gst_tax']);
$('.tot_tr:last-child').find('.tax_amt').val(VALUE['tax_amt']);

$('.tot_tr:last-child').find('.product_csgst_per').val(VALUE['product_csgst_per']);


$('.tot_tr:last-child').find('.product_csgst_amt').val(VALUE['product_csgst_amt']);
$('.tot_tr:last-child').find('.product_ssgst_per').val(VALUE['product_ssgst_per']);
$('.tot_tr:last-child').find('.product_ssgst_amt').val(VALUE['product_ssgst_amt']);
$('.tot_tr:last-child').find('.product_isgst_per').val(VALUE['product_isgst_per']);
$('.tot_tr:last-child').find('.product_isgst_amt').val(VALUE['product_isgst_amt']);
$('.tot_tr:last-child').find('.product_kfc_per').val(VALUE['product_kfc_per']);
$('.tot_tr:last-child').find('.product_kfc_amt').val(VALUE['product_kfc_amt']);

$('.tot_tr:last-child').find('.product_cost').val(VALUE['product_cost']);
$('.tot_tr:last-child').find('.product_total').val(VALUE['product_total']);

add_grid();
});
					  				
						/*
						  $('#dyn_table_id').attr('nbr',ResArr[1]);
						*/
						
						
						
				}
					
		 });
   	
}





function fetch_opening_bal(acc_head_id)
{
	
	$.ajax({
                type: 'POST',
				async:false,
                url: 'fetch_accounthead_opening_bal_voucher_entry.php',
				 data: {
                    acc_head_id: acc_head_id
                },

				error: function (request, error) {
                    alert("Please Wait, Loading...");
                },
                success: function (response) {	
				$('#current_balance').html("Current Balance:"+response);	
				}
            });
			

}



function view_hidden_tds()
{
$('#view_eye').hide(); 
$('#view_eye').attr('st',1);      
$('#hide_eye').show();
$('.d-none-td').show();

}


function hide_hidden_tds()
{
$('#hide_eye').hide();
$('#view_eye').show();
$('#view_eye').attr('st',0);
$('.d-none-td').hide();

}

