var commonUrl = 'https://trafiqerp.in/rapi_xp/';
var charts = [];
var chartData =[];
var columAlignArr = {
    L: "left",
    R: "right",
    C: "center"
};

var colorSets = [
  { 
    primary: "#6f42c1", // Purple
    secondary: "#7f62b3", 
    darkShade: "#4b2a84", 
    lightShade: "#9b76e4" 
  },
  { 
    primary: "#007bff", // Blue
    secondary: "#0056b3", 
    darkShade: "#004085", 
    lightShade: "#66b2ff" 
  },
  { 
    primary: "#28a745", // Green
    secondary: "#218838", 
    darkShade: "#19692c", 
    lightShade: "#71dc91" 
  },
  { 
    primary: "#dc3545", // Red
    secondary: "#b02a37", 
    darkShade: "#7a1c24", 
    lightShade: "#f77c8a" 
  },
  { 
    primary: "#17a2b8", // Teal
    secondary: "#138496", 
    darkShade: "#0d4d56", 
    lightShade: "#70d7e2" 
  },
  { 
    primary: "#fd7e14", // Orange
    secondary: "#e8590c", 
    darkShade: "#b0430a", 
    lightShade: "#ffb176" 
  }
];

function applyColorSet() {
 var i=0;



    $('.branchSpan').each(function(index, value) {

        if(colorSets.length==i)
        {
        i=0;
        }

        $(this).css('background-image', 'linear-gradient(45deg, '+colorSets[i].primary+', '+colorSets[i].lightShade+')');
        $(this).attr('colorId',i);
        i++;
    });
}


$(document).ready(function() {

    $('#companyName').on('click', function() {
        window.location.href = 'dashboard.php';
    });

   

    $('#collapseDiv').on('show.bs.collapse', function () {
    $('#toggleIcon').removeClass('bi-caret-down-fill').addClass('bi-caret-up-fill');
  }).on('hide.bs.collapse', function () {
    $('#toggleIcon').removeClass('bi-caret-up-fill').addClass('bi-caret-down-fill');
  });


  $('#collapseDiv2').on('show.bs.collapse', function () {
    $('#toggleIcon2').removeClass('bi-caret-down-fill').addClass('bi-caret-up-fill');
  }).on('hide.bs.collapse', function () {
    $('#toggleIcon2').removeClass('bi-caret-up-fill').addClass('bi-caret-down-fill');
  });





    $('#companyName').html(localStorage.getItem('c_name'));

    tabStr = '';
    tabStr2 = '';
    branchStr = '';

    tab2count=0;


    $.ajax({
        url: commonUrl+'initialize.php',
        type: 'POST',
        data: {
            c_id: localStorage.getItem('c_id'),
            user_id: localStorage.getItem('user_id')
        },
        success: function(response) {
            res = JSON.parse(response);
            tabs = res.tabs;
            branch_ids = res.branchs[0].branch_ids;
            branch_names = res.branchs[0].branch_names;

            branchArr = branch_ids.split(',');
            branchNameArr = branch_names.split(',');

            $.each(tabs, function(index, value) {

                if(parseInt(value.menu_type)==0)
                {
                tabStr += '<span class="tabSpan cap" tab_id="' + value.tab_id +
                    '" onClick="setTab(this);" menu_type="'+value.menu_type+'" date_criteria="'+value.date_criteria+'" >' + value.tab_name + '</span>';
                }
                else{
                    tabStr2 += '<span class="tabSpan cap" tab_id="' + value.tab_id +
                    '" onClick="setTab(this);"  menu_type="'+value.menu_type+'"  date_criteria="'+value.date_criteria+'" >' + value.tab_name + '</span>'; 
                    tab2count++; 
                }


            });

           

            $.each(branchArr, function(index, value) {
                branchStr += '<span class="branchSpan cap" branch_id="' + value +
                    '"  onClick="setBranch(this);">' + branchNameArr[index] + '</span>';
            });

            $('#tabsDiv').html(tabStr);
            if(tab2count>0){
                $('#customReportBtn').show();
                $('#tabsDiv2').html(tabStr2); 
            }
            else{
                $('#customReportBtn').hide();
            }
            
            $('#branchesDiv').html(branchStr);

            $('#choosenTab').val($('span.tabSpan:first').attr('tab_id'));
            $('#choosenBranch').val($('span.branchSpan:first').attr('branch_id'));
            $('#choosenBranch').attr('colorId',0);

            
            
            $('#tabNameSpan').html($('span.tabSpan:first').text());
            $('#tabNameSpan2').html($('span.tabSpan:first').text());
            $('#branchNameSpan').html($('span.branchSpan:first').text());

            applyColorSet();

            setTimeout(() => {
                loadTabData();
            }, 200);

        },
        error: function(xhr, status, error) {

        }
    });



    
    $(document).on('input', '.searchField', function () {
        var searchValue = $(this).val().toLowerCase();
        var reportId = $(this).attr('reportId');
        var searchcolumn = parseInt($(this).attr('searchcolumn') -1);

        $('table[reportId="' + reportId + '"] tr:gt(1)').each(function () {
            console.log($(this).find('td:eq(' + searchcolumn + ')').text());
        $(this).toggle($(this).find('td:eq(' + searchcolumn + ')').text().toLowerCase().indexOf(searchValue) > -1);
        });
    });

});


function openCustomReport()
{
   
    window.location.href = "customReport.php";
}




function logout()
{
    localStorage.setItem('autologin',0);
    window.location.href = "index.php";
}



function loadDatePicker()
{
    $(".dateClass").datepicker({
            dateFormat: "dd-mm-yy",
            changeMonth: true,
            changeYear: true 
        });
}
    



function changeChartType(elm)
{
    var chartId = $(elm).attr('chartno');

    colorId = $('#choosenBranch').attr('colorId');

    primaryColor=colorSets[colorId].primary;
    lightShade=colorSets[colorId].lightShade;

    var chartArrId =parseInt(chartId) - 1;
    var newType = $(elm).val();

    if (charts[chartArrId]) {
        charts[chartArrId].destroy();
    }

    if(newType=='pie' || newType=='doughnut')
    {
    chartData[chartArrId].datasets[0].backgroundColor=colorSets.map(set => set.lightShade);
    chartData[chartArrId].datasets[0].borderColor =colorSets.map(set => set.darkShade);
    }
    else{
    chartData[chartArrId].datasets[0].backgroundColor=lightShade;
    chartData[chartArrId].datasets[0].borderColor =primaryColor;
    }

    var config = {
        type: newType, // Default type
        data: chartData[chartArrId],
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    };
   
    setTimeout(() => {
        charts[chartArrId] = new Chart(
        document.getElementById('chart'+chartId),
        config
    );
}, 200);
}


function setTab(elm) {
    $('#choosenTab').val($(elm).attr('tab_id'));
   
    $('#tabNameSpan2,#tabNameSpan').html('');
    if($(elm).attr('menu_type')==0)
    {        
        $('#tabNameSpan').html($(elm).text());
    }
    else{
        $('#tabNameSpan2').html($(elm).text());
    }  
   
    loadTabData();
}

function setBranch(elm) {
    $('#collapseDiv').collapse('toggle');
    colorId=$(elm).attr('colorId');
    $('#choosenBranch').val($(elm).attr('branch_id'));
    $('#choosenBranch').attr('colorId',$(elm).attr('colorId'));
    $('.tabSpan').css('background-image', 'linear-gradient(45deg, '+colorSets[colorId].primary+', '+colorSets[colorId].secondary+')');
    $('#branchNameSpan').html($(elm).text());
    loadTabData();
}


function loadTabData() {

    b_id = $('#choosenBranch').val();
    colorId = $('#choosenBranch').attr('colorId');
    tab_id = $('#choosenTab').val();

    primaryColor=colorSets[colorId].primary;
    secondaryColor=colorSets[colorId].lightShade;

    date_criteria = $('span.tabSpan[tab_id="'+tab_id+'"]').attr('date_criteria');

    destroyAllCharts();


    if(date_criteria=='1')
    {
        from_date = $('#from_date2').val();
        $('#chartCounter').attr('from_date2',from_date);
        till_date = from_date;
    }
    else if(date_criteria=='2')
    {
        from_date = $('#from_date').val();
        till_date = $('#till_date').val();
        $('#chartCounter').attr('from_date',from_date);
        $('#chartCounter').attr('till_date',till_date);
    }
   
    //console.log("date_criteria"+date_criteria+" // from_date"+from_date+" // till_date"+till_date);
    if ((typeof from_date === "undefined" && date_criteria=='1') || (typeof from_date === "undefined" && date_criteria=='0')) {
        const currentDate = new Date(); 
        var day = ("0" + currentDate.getDate()).slice(-2); 
        var month = ("0" + (currentDate.getMonth() + 1)).slice(-2); 
        var year = currentDate.getFullYear(); 
        from_date =day + "-" + month + "-" + year;
        till_date = from_date;
    }
    else if(typeof from_date === "undefined" && typeof till_date === "undefined" && date_criteria=='2')
    {
        var currentDate = new Date(); 
        var day = ("0" + currentDate.getDate()).slice(-2); 
        var month = ("0" + (currentDate.getMonth() + 1)).slice(-2); 
        var year = currentDate.getFullYear(); 
        till_date =day + "-" + month + "-" + year;

        var currentDate2 = new Date();
        currentDate2.setDate(currentDate2.getDate() - 7); 

        var day2 = ("0" + currentDate2.getDate()).slice(-2); 
        var month2 = ("0" + (currentDate2.getMonth() + 1)).slice(-2); 
        var year2 = currentDate2.getFullYear();
        from_date =day2 + "-" + month2 + "-" + year2;
    }

    //console.log("date_criteria"+date_criteria+" // from_date"+from_date+" // till_date"+till_date);

    $('#tabResults').html('<img src="images/lg.gif"   style="width:100%" />');


    tabResultStr = '';
    $.ajax({
        url: commonUrl+'load_report.php',
        type: 'POST',
        data: {
            c_id: localStorage.getItem('c_id'),
            b_id: b_id,
            user_id: localStorage.getItem('user_id'),
            tab_id: tab_id,
            from_date: from_date,
            till_date: till_date
        },
        success: function(response) {
            res = JSON.parse(response);

            
            if(date_criteria=='1')
                {
                    from_date=$('#chartCounter').attr('from_date2');
                    tabResultStr += '<div class="container">';
                    tabResultStr += '<div class="row align-items-center">';
                    tabResultStr += '<div class="col-6">';
                    tabResultStr += '<label for="from_date" class="form-label">From Date:</label>';
                    tabResultStr += '</div>';
                    tabResultStr += '<div class="col-6">';
                    tabResultStr += '<input type="text" id="from_date2" value="'+from_date+'" readonly class="dateClass form-control" onChange="loadTabData();"  >';
                    tabResultStr += '</div>';
                    tabResultStr += '</div>';
                    tabResultStr += '</div>';

                    tabResultStr += '<hr>';
                }
                else if(date_criteria=='2')
                {

                    from_date=$('#chartCounter').attr('from_date');
                    till_date=$('#chartCounter').attr('till_date');


                    tabResultStr += '<div class="row form-floating">';
                    tabResultStr += '<div class="col-6 ">';
                    tabResultStr += '<label for="from_date"  class="form-label">From Date:</label>';

                    tabResultStr += '<input type="text" id="from_date" class="dateClass form-control"  readonly  value="'+from_date+'" onChange="loadTabData();" >';
                    tabResultStr += '</div>';
                    tabResultStr += '<div class="col-6  ">';
                    tabResultStr += '<label for="till_date"  class="form-label">Till Date:</label>';
                 
                    tabResultStr += '<input type="text" id="till_date" class="dateClass form-control"  readonly  value="'+till_date+'" onChange="loadTabData();" >';
                    tabResultStr += '</div>';
                    tabResultStr += '</div>';

                    tabResultStr += '<hr>';
                }
                else{
                    tabResultStr += '';
                }

            $.each(res, function(index, value) {
                title = value.title;
                tabWidth = value.width;
                graph = value.graph;
                data = value.data;
                searchField = value.search;
                reportId = value.id;

               

                if (parseInt(graph) == 1) {

                    chartCounter = $('#chartCounter').val();
                    chartCounter++;


                    tabResultStr += '<div>';
                    tabResultStr += '<label for="chartType">Choose Chart Type:</label>';
                    tabResultStr += '<select class="chartType" chartNo="' + chartCounter + '"  onChange="changeChartType(this);">';
                    tabResultStr += '<option value="bar" selected>Bar</option>';
                    tabResultStr += '<option value="line">Line</option>';
                    tabResultStr += '<option value="pie">Pie</option>';
                    tabResultStr += '<option value="doughnut">Doughnut</option>';
                    tabResultStr += '</select>';
                    tabResultStr += '</div>';

                    tabResultStr += '<div id="chartContainer" style="width:100%; height:300px">';
                    tabResultStr += '<canvas id="chart' + chartCounter + '"></canvas>';
                    tabResultStr += '</div>';
                    $('#chartCounter').val(chartCounter);

                }

                columnArr = tabWidth.split(',');
                columnAlign = value.align.split('');
                columnSum = value.sum.split('');
                columnSumArr = [];
                columnCount = columnArr.length;


            

                if (data.length > 0) {

                    if(parseInt(searchField) >= 1)
                    {
                    var secarchKey =  Object.keys(data[0])[(searchField-1)];
                    tabResultStr += '<div class="row form-floating">';
                    tabResultStr += '<div class="col-8 ">';
                    tabResultStr += '<input type="text" class="form-control searchField" reportId="' + reportId + '" value="" placeholder="Search '+secarchKey+'" searchColumn="'+searchField+'" >';   
                    tabResultStr += '</div>';
                    tabResultStr += '</div>';
                    }

                    tabResultStr += '<table class="table table-dark table-striped" reportId="' + reportId + '">'
                    tabResultStr += '<tr><td  class="boldRow" align="center" colspan="' + columnCount + '">' + title + '</td></tr>';

                    var j = 0;
                    $.each(data, function(index2, value2) {
                        var i = 0;


                        if (j == 0) {

                            tabResultStr += '<tr>';
                            $.each(value2, function(index3, value3) {
                                tabResultStr += '<td class="boldRow" width="' + columnArr[i] +
                                    '"  align="' + columAlignArr[columnAlign[j]] + '" >' + index3 + '</td>';
                                columnSumArr[j] = 0;
                                j++;
                            });
                            tabResultStr += '</tr>';
                            
                        }

                        tabResultStr += '<tr>';
                        $.each(value2, function(index3, value3) {

                            if(i>0)
                            {
                           
                            textVal=parseFloat(value3);

                           if(isNaN(textVal)){
                              txtData=value3;
                           }else{
                            txtData=textVal.toFixed(2);
                           } 
                           
                            }
                            else
                            {
                            txtData=value3;
                            }

                            tabResultStr += '<td  align="' + columAlignArr[columnAlign[i]] + '">' + txtData + '</td>';
                            columnSumArr[i] += parseFloat(value3) || 0;
                            i++;
                        });
                        tabResultStr += '</tr>';

                    });

                    // console.log(columnSumArr);

                    tabResultStr += '<tr>';
                    var s = 0;
                    $.each(columnSumArr, function(index3, value3) {
                        if (columnSum[s] == "N") {
                            value3 = "";
                        }
                        else{
                            value3 = parseFloat(value3); 
                            value3 = value3.toFixed(2);
                        }
                        tabResultStr += '<td class="boldRow" align="right">' + value3 + '</td>';
                        s++;
                    });
                    tabResultStr += '</tr>';

                    tabResultStr += '</table>';

                tabResultStr += '<hr>';

                }

                


            });

            $('#tabResults').html(tabResultStr);

            loadDatePicker();

            $('.table-dark').css('--bs-table-bg', primaryColor); // Example new color
            $('.table-striped>tbody>tr:nth-of-type(odd)>*').css('--bs-table-bg-type', secondaryColor);

            k = 1;
            $.each(res, function(index, value) {

                title = value.title;
                graph = value.graph;
                data = value.data;

                if (parseInt(graph) == 1) {
                    createGraph(title, data, k);
                    k++;
                }
            });

        },
        error: function(xhr, status, error) {

        }
    });



}



function destroyAllCharts() {
    charts.forEach(function(chart) {
        chart.destroy();
    });
    charts = [];
    $('#chartCounter').val(0);
}


function createGraph(title, data2, chartCounter) {

    colorId = $('#choosenBranch').attr('colorId');

    primaryColor=colorSets[colorId].primary;
    lightShade=colorSets[colorId].lightShade;


    var labels = [];
    var dataSet = [];
    // console.log(chartCounter);
    // console.log(data2);

    $.each(data2, function(index, value) {
        i = 0;
        $.each(value, function(index1, value1) {
            if (i == 0) {
                labels.push(value1);
            } else {
                dataSet.push(value1);
            }


            i++;
        });
    });


    var data = {
        labels: labels,
        datasets: [{
            label: title,
            backgroundColor: lightShade,
            borderColor: primaryColor,
            borderWidth: 1,
            data: dataSet,
        }]
    };

    chartData.push(data);

    var config = {
        type: 'bar', // Default type
        data: data,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    };

    var myChart = new Chart(
        document.getElementById('chart' + chartCounter),
        config
    );

    charts.push(myChart);

}



