<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="css/bootstrap.css" rel="stylesheet" >
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.js" > </script>

    <style>
    /* Custom CSS for styling */
    body {
      background-color: #f4f7fa; /* Light background color */
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }

    .login-container {
      background-color: #fff;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      width: 100%;
      max-width: 400px;
    }

    .login-title {
      text-align: center;
      margin-bottom: 20px;
    }

    .login-btn {
      background-color: #6f42c1;
      color: #fff;
      border: none;
    }

    .login-btn:hover {
      background-color: #7f62b3 !important;
    }

  </style>

</head>
<body>


<div class="login-container"  id="registrationDiv" style="display: none;">
    <h3 class="login-title">Registration</h3>
    <form>
      <div class="mb-3">
        <label for="username" class="form-label">Enter Registration key</label>
        <input type="text" class="form-control" id="regKey" placeholder="Enter Registration key">
      </div>
      <button type="button" class="btn btn-primary w-100 login-btn" onclick="register();">Register</button>
    </form>
  </div>


<div class="login-container" id="loginDiv" style="display: none;">
    <h3 class="login-title">Login</h3>
    <form>
      <div class="mb-3">
        <label for="username" class="form-label" >Username</label>
        <input type="text" class="form-control" id="user" placeholder="Enter your username">
      </div>
      <div class="mb-3">
        <label for="password" class="form-label">Password</label>
        <input type="password" class="form-control" id="pass" placeholder="Enter your password">
      </div>
      
      
      <button type="button" class="btn btn-primary w-100 login-btn" onClick="login();">Login</button>
      
      <button type="button" class="btn btn-primary w-100" onClick="unregister();">...</button>
       
    </form>
  </div>


</body>
</html>
<script>
var commonUrl = 'https://trafiqerp.in/rapi_xp/';
    $(document).ready(function() {

        if(localStorage.getItem('device_id')){
           
                checkFingerPrint();  
            
           
        }
        else{  


        if(localStorage.getItem('c_id')){

            if(!localStorage.getItem('user_id')){
                $("#registrationDiv").hide();
                $("#loginDiv").show();
            }
        }
        else{
           $("#loginDiv").hide();
           $("#registrationDiv").show();
           
        }

    }
    });



function unregister() {
   $("#loginDiv").hide();
           $("#registrationDiv").show();
}

function generateUniqueID() {
  let deviceID = localStorage.getItem('device_id');
  
  if (!deviceID) {
    deviceID = 'D' + Math.random().toString(36).substr(2, 11);
    localStorage.setItem('device_id', deviceID);
  }

  return deviceID;
}


function register(){
    var regKey = $("#regKey").val();
    var deviceID = generateUniqueID();
    $.ajax({
        url: commonUrl+'web_register.php',
        type: 'POST',
        data: {
            regKey: regKey,
            deviceID:deviceID
        },
        success: function(response) {
            response = JSON.parse(response);
            if (parseInt(response.status) == 1 ) {
                localStorage.setItem('c_id', response.c_id);
                localStorage.setItem('c_name', response.c_name);

                $("#registrationDiv").hide();
                $("#loginDiv").show();
            }
            else{
                alert(response.message);
            }
        },
        error: function(xhr, status, error) {
            console.log(error);
        }

    });
}



function login(){
    var user = $("#user").val();
    var pass = $("#pass").val();
    var deviceID = localStorage.getItem('device_id');
    var c_id = localStorage.getItem('c_id');
    $.ajax({
        url: commonUrl+'web_login.php',
        type: 'POST',
        data: {
            user: user,
            pass: pass,
            deviceID:deviceID,
            c_id:c_id
        },
        success: function(response) {
            response = JSON.parse(response);
            if (parseInt(response.status)== 1 ) {
                localStorage.setItem('user_id', response.user_id);
                localStorage.setItem('autologin',1);
               
                window.location.href = "dashboard.php";
            }
            else{
                $("#registrationDiv").hide();
                $("#loginDiv").show();
            }
        },
        error: function(xhr, status, error) {
            console.log(error);
        }

    });
}


function checkFingerPrint(){

    $.ajax({
        url: commonUrl+'web_checkFingerPrint.php',
        type: 'POST',
        data: {
            deviceID: localStorage.getItem('device_id')
        },
        success: function(response) {
            response = JSON.parse(response);

            if (parseInt(response.status) == 1 ) {
                if(localStorage.getItem('autologin')==1){
                window.location.href = "dashboard.php";
                }
                else if(localStorage.getItem('autologin')==0){
                    $("#registrationDiv").hide();
                    $("#loginDiv").show();
                }
                else{
                $("#loginDiv").hide();
                $("#registrationDiv").show(); 
                }
            }
            else{
                $("#loginDiv").hide();
                $("#registrationDiv").show(); 
            }

        },
        error: function(xhr, status, error) {
            console.log(error);
        }

    });
}



</script>