<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title></title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">

    <link href="css/bootstrap.css" rel="stylesheet" >
    <script src="js/chart.js" ></script>

    <link rel="stylesheet" href="css/jqueryUI.css">

    <script src="js/jquery.js"></script>

    <script src="js/bootstrap.js" > </script>

    <script src="js/jqueryUI.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
    body {
        font-family: 'Roboto', sans-serif;
    }

    
    #tabsDiv {
        margin-bottom: 5px;
        width: 100%;
        height:50px;
        overflow-y: auto;        
        white-space: nowrap;
    }

    .tabSpan {
        padding: 5px;
        /* border: 1px solid black; */
        border-radius: 5px;
        margin: 5px;
         background-image: linear-gradient(45deg, #6f42c1, #7f62b3); 
        display: inline-block;
        color: white;
    }

    .branchSpan {
        padding: 5px;
        /* border: 1px solid black; */
        border-radius: 5px;
        margin: 5px;
       
        display: inline-block;
        color: white;
    }

    .tabSpan:hover,
    .branchSpan:hover {
        cursor: pointer;
    }


    .table-dark {
    --bs-table-color: #fff;
    --bs-table-bg: #6f42c1;

    }

    .table-striped>tbody>tr:nth-of-type(odd)>* {
    --bs-table-bg-type: #7f62b3;
    }



    #tabResults{
        width: 100%;
        padding: 5px;
    }

    #tabResults table{
       width: 100%; 
    }

    .boldRow{
        font-weight: bold;
    }


    .divHeaderSpace{
        height: 50px;   
    }

    .header {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 60px;
      background-image: linear-gradient(45deg, #6f42c1, #7f62b3);
      color: white;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0 20px;
      z-index: 1000;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    }

    .header .logo {
      font-size: 18px;
      font-weight: bold;
    }

    .header .logout-btn {
      background-color: #6f42c1;
      color: white;
      border: 1px solid white;
      padding: 8px 15px;
      border-radius: 4px;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s ease;
      font-weight: bold;
    }

    .header .logout-btn:hover {
      background-color: #7f62b3;
      color: white;
    }

    .cap {
    text-transform: lowercase;
    }

    .cap::first-letter {
    text-transform: uppercase;
    }

    h5{
        font-size: 0.83rem;
    }

    .card-header,.card-body{
        padding-top: 1px;
        padding-bottom: 1px;
    }
    
    </style>

</head>

<body>

<div class="header">
    <div class="logo" id="companyName">Company Name</div>

    <i class="bi bi-card-heading" id="customReportBtn" onclick="openCustomReport();" st="0" style=" font-size: 30px;  position: absolute;
    right: 120px;"></i>
    <button class="logout-btn" onClick="logout();">Logout</button>
</div>

<div class="divHeaderSpace"></div>

<div class="container mt-4">
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="mb-0">Branch : <span id="branchNameSpan"></span></h5>
      <button class="btn btn-link text-decoration-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseDiv" aria-expanded="true" aria-controls="collapseDiv">
        <i class="bi bi-caret-down-fill" id="toggleIcon"></i>
      </button>
    </div>
    <div id="collapseDiv" class="collapse">
      <div class="card-body"  id="branchesDiv" >
       
      </div>
    </div>
  </div>
</div>


<div class="container mt-2">
<div class="card" style="padding: var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x);">
    <h5>Report:<span id="tabNameSpan"></span></h5>
    <div id="tabsDiv"></div>
</div>
</div>
   
   

<input type="hidden" id="chartCounter" value="0" from_date2="<?php echo date('d-m-Y'); ?>" till_date="<?php echo date('d-m-Y'); ?>"  from_date="<?php echo date('d-m-Y', strtotime('-7 days')); ?>" />
    <input type="hidden" id="choosenBranch" value="0" />
    <input type="hidden" id="choosenTab" value="0" />

    <div id="tabResults">

    </div>


</body>

<script src="js/vegaReportSripts.js"></script>

</html>